; The EN registers - the DS8390 chip registers 
; There are two (really 3) pages of registers in the chip. You select 
; which page you want, then address them at offsets 00-0F from base. 
; The chip command register (EN_CCMD) appears in both pages. 
; EN_OFF is the offset from the board's base register to the EN registers. 
;
.equ eaddr_len = 6 ;               bytes in an ether address 
;
.equ en_ccmd = 0x000 ;      Chip's command register 
;
; Page 0 
;
.equ en0_cldalo = 0x001 ;  	 Low byte of current local dma addr  RD 
.equ en0_startpg = 0x001 ;  	 Starting page of ring bfr WR 
.equ en0_cldahi = 0x002 ;  	 High byte of current local dma addr  RD 
.equ en0_stoppg = 0x002 ;  	 Ending page +1 of ring bfr WR 
.equ en0_boundary = 0x003 ;  	 Boundary page of ring bfr RD WR 
.equ en0_tsr = 0x004 ;  	 Transmit status reg RD 
.equ en0_tpsr = 0x004 ;  	 Transmit starting page WR 
.equ en0_ncr = 0x005 ;  	 Number of collision reg RD 
.equ en0_tcntlo = 0x005 ;  	 Low  byte of tx byte count WR 
.equ en0_fifo = 0x006 ;  	 FIFO RD 
.equ en0_tcnthi = 0x006 ;  	 High byte of tx byte count WR 
.equ en0_isr = 0x007 ;  	 Interrupt status reg RD WR 
.equ en0_crdalo = 0x008 ;  	 low byte of current remote dma address RD 
.equ en0_rsarlo = 0x008 ;  	 Remote start address reg 0 
.equ en0_crdahi = 0x009 ;  	 high byte of current remote dma address RD 
.equ en0_rsarhi = 0x009 ;  	 Remote start address reg 1 
.equ en0_rcntlo = 0x00a ;  	 Remote byte count reg WR 
.equ en0_rcnthi = 0x00b ;  	 Remote byte count reg WR 
.equ en0_rsr = 0x00c ;  	 rx status reg RD 
.equ en0_rxcr = 0x00c ;  	 RX control reg WR 
.equ en0_txcr = 0x00d ;  	 TX control reg WR 
.equ en0_counter0 = 0x00d ;  	 Rcv alignment error counter RD 
.equ en0_dcfg = 0x00e ;  	 Data configuration reg WR 
.equ en0_counter1 = 0x00e ;  	 Rcv CRC error counter RD 
.equ en0_imr = 0x00f ;  	 Interrupt mask reg WR 
.equ en0_counter2 = 0x00f ;  	 Rcv missed frame error counter RD 
;
; Page 1 
;
.equ en1_phys = 0x001 ;  	 This board's physical enet addr RD WR 
.equ en1_curpag = 0x007 ;  	 Current memory page RD WR 
.equ en1_mult = 0x008 ;  	 Multicast filter mask array (8 bytes) RD WR 
;
; Chip commands in EN_CCMD 
.equ enc_stop = 0x001 ;  	 Stop the chip 
.equ enc_start = 0x002 ;  	 Start the chip 
.equ enc_trans = 0x004 ;  	 Transmit a frame 
.equ enc_rread = 0x008 ;  	 remote read 
.equ enc_rwrite = 0x010 ;  	 remote write 
.equ enc_nodma = 0x020 ;  	 No remote DMA used on this card 
.equ enc_page0 = 0x000 ;  	 Select page 0 of chip registers 
.equ enc_page1 = 0x040 ;  	 Select page 1 of chip registers 
.equ enc_page2 = 0x080 ;         page 2
.equ enc_page3 = 0x0c0 ;         page 3 (Realtek RTL8019AS chip)
;
; Commands for EN0_RXCR - RX control reg 
.equ enrxcr_crc = 0x001 ;  	 Save error pkts 
.equ enrxcr_runt = 0x002 ;  	 Accept runt pkt 
.equ enrxcr_bcst = 0x004 ;  	 Accept broadcasts 
.equ enrxcr_multi = 0x008 ;  	 Multicast (if pass filter) 
.equ enrxcr_promp = 0x010 ;  	 Promiscuous physical addresses 
.equ enrxcr_mon = 0x020 ;  	 Monitor mode (no packets rcvd) 
;
; Bits in EN0_TXCR - transmit control reg 
.equ entxcr_crc = 0x001 ;  		 inhibit CRC, do not append crc 
.equ entxcr_loop = 0x002 ;  		 Set loopback mode 
.equ entxcr_lb01 = 0x006 ;  		 encoded loopback control 
.equ entxcr_atd = 0x008 ;  		 auto tx disable 
.equ entxcr_ofst = 0x010 ;  		 collision offset enable 
;
; Bits in EN0_DCFG - Data config register 
#ifdef BYTEWIDE_DBUS
.equ endcfg_wts = 0x000 ;  	 byte transfer mode selection 
#else
.equ endcfg_wts = 0x001 ;  	 word transfer mode selection 
#endif
.equ endcfg_bos = 0x002 ;  	 byte order selection 
.equ endcfg_las = 0x004 ;  	 long addr selection 
.equ endcfg_bms = 0x008 ;  	 burst mode selection 
.equ endcfg_arm = 0x010 ;  	 autoinitialize remote 
.equ endcfg_ft00 = 0x000 ;  	 burst length selection 
.equ endcfg_ft01 = 0x020 ;  	 burst length selection 
.equ endcfg_ft10 = 0x040 ;  	 burst length selection 
.equ endcfg_ft11 = 0x060 ;  	 burst length selection 
;
; Bits in EN0_ISR - Interrupt status register 
.equ enisr_rx = 0x001 ;  	 Receiver, no error 
.equ enisr_tx = 0x002 ;  	 Transmitter, no error 
.equ enisr_rx_err = 0x004 ;  	 Receiver, with error 
.equ enisr_tx_err = 0x008 ;  	 Transmitter, with error 
.equ enisr_over = 0x010 ;  	 Receiver overwrote the ring 
.equ enisr_counters = 0x020 ;  	 Counters need emptying 
.equ enisr_rdc = 0x040 ;  	 remote dma complete 
.equ enisr_reset = 0x080 ;  	 Reset completed 
;
.equ enisr_all = 0x03f ;  	 Interrupts we will enable 
;
; Bits in received packet status byte and EN0_RSR 
.equ enrsr_rxok = 0x001 ;  	 Received a good packet 
.equ enrsr_crc = 0x002 ;  	 CRC error 
.equ enrsr_fae = 0x004 ;  	 frame alignment error 
.equ enrsr_fo = 0x008 ;  	 FIFO overrun 
.equ enrsr_mpa = 0x010 ;  	 missed pkt 
.equ enrsr_phy = 0x020 ;  	 physical/multicase address 
.equ enrsr_dis = 0x040 ;  	 receiver disable. set in monitor mode 
.equ enrsr_def = 0x080 ;  	 deferring 
;
; Bits in EN0_TSR -  TX status reg 
;
.equ entsr_ptx = 0x001 ;  	 Packet transmitted without error 
.equ entsr_dfr = 0x002 ;  	 non deferred tx 
.equ entsr_coll = 0x004 ;  	 Collided at least once 
.equ entsr_coll16 = 0x008 ;  	 Collided 16 times and was dropped 
.equ entsr_crs = 0x010 ;  	 carrier sense lost 
.equ entsr_fu = 0x020 ;  	 TX FIFO Underrun 
.equ entsr_cd = 0x040 ;  	 collision detect heartbeat 
.equ entsr_owc = 0x080 ;  	 out of window collision 
;
; Description of header of each packet in receive area of memory 
;
.equ en_rbuf_stat = 0 ;  	 Received frame status 
.equ en_rbuf_nxt_pg = 1 ;  	 Page after this frame 
.equ en_rbuf_size_lo = 2 ;  	 Length of this frame 
.equ en_rbuf_size_hi = 3 ;  	 Length of this frame 
.equ en_rbuf_nhdr = 4 ;  	 Length of above header area 
;
