#include "bootp.h"
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------
;+
; **-bootp-bootp support routines.
;
; this module implements the BOOTP protocol, as described in RFC951.
;
; although there is every attempt to adhere to RFC951, this code has not
; yet been tested with a "real" BOOTP server - so it might need some
; tweaking for that.  the server was developed at the same time this
; code was written, and it has at least been verified that this client
; can talk to THAT server!
;
; the basic idea is to send a UDP broadcast to 255.255.255.255:bootp, and
; expect a reply TO 255.255.255.255:68 (68 appears to be a canonical request
; port).  in the request PAYLOAD is our own ethernet address, our current
; IP address (even though it might be bogus), and some control flags.
;
; when the reply comes back, we check to make sure it is to port 68, and
; that the ethernet address (again, in the PAYLOAD) matches ours, and also
; that the operation type is "reply".  if all of these tests pass, the
; packet is accepted as valid, and our IP address is changed to the one
; included in the request packet.
;-

bootp:
#if !defined(BOOTP_DISABLED)
    rcall pcode
#if defined(TCP_CHECKSUM_ON_THE_FLY)
    .dw pclrw,tcpchk
#endif
	.dw pi2x,0,0xffff
	.dw pi2x,2,0xffff
	.dw pi2x,4,0xffff				; dest ether = FF:FF:FF:FF:FF:FF

	SET_IP(pi2x,IP_SRCADDR,0,0,0,1) ;            ; 0.0.0.1
    .dw pi2x,UDP_SP,BSWAP(BOOTP_REPLY_PORT)      ;  :reply_port

	SET_IP(pi2x,IP_DSTADDR,255,255,255,255)	    ; 255.255.255.255
    .dw pi2x,UDP_DP,BSWAP(BOOTP_REQUEST_PORT)    ;  :bootp

    .dw pi2x,IP_LEN,BSWAP(IP_HEADER_LEN+UDP_HEADER_LEN+BOOTP_LEN)
    .dw pi2x,UDP_LEN,BSWAP(UDP_HEADER_LEN+BOOTP_LEN)

    .dw pz2x,BOOTP_OP,BOOTP_LEN      ; zero UDP data portion of xmit buffer

    .dw pi2x,BOOTP_OP,0x0101         ; optype=01 (req), hwtype=01 (ether)
    .dw pi2x,BOOTP_HLEN,0x0006       ; addrlen=06 (ether), hops=00
    .dw ps2x,BOOTP_CHADDR,my_ether,6 ; insert my ether address
    .dw ps2x,BOOTP_CIADDR,my_ip,4    ;  and my IP address (even if wrong)
    .dw pcall,ip_header_1           ; do header except ip addresses
    .dw pcall,udp_checksum
    .dw px2s,buf,IP_LEN,2            ; read back the length
    .dw pmovwi|XX,buf,SWAP(WORD(buf)) ; swap bytes
    .dw paddwi,buf,6+6+2            ; compute length with ether header
    .dw xmit_frame|XX,WORD(buf)		; out she goes
    .dw 0
#endif
    ret
bootp_reply:
#if !defined(BOOTP_DISABLED)
;
; pCode entry point from frame.asm when we smell a BOOTP reply packet.
;
    .dw pr2s,buf,BOOTP_CHADDR,6      ; get the ethernet address
    .dw pcmpn,buf,my_ether,6         ; see if it's my ether address
    .dw pjumpne,drop_it              ; nope - it stinks
    .dw pr2s,buf,BOOTP_OP,2          ; get optype and hwtype
    .dw pcmpwi,buf,0x0102           ; BOOTREPLY(02), ETHER(01)
    .dw pjumpne,drop_it              ; sorry - not a good reply packet
#if defined(BOOTP_DEBUG)
    .dw pprintr,bipmsg,BOOTP_YIADDR,4,pcrlf    ;;string bipmsg "IP"
#endif
    .dw pr2s,my_ip,BOOTP_YIADDR,4    ; change my IP address
#endif  /* BOOTP_DISABLED */
    .dw 0
bootp_bail:
    ret
;+
; **-bootp_timer-timer expiration.
;
; this routine is called whenever the bootp timer expires.  if we don't know our
; IP address yet, then generate another bootp request.
;-

bootp_timer:
#if !defined(BOOTP_DISABLED)
    lds r0,my_ip                    ; get first byte of IP address
    or r0,r0
    brne bootp_bail
    rjmp bootp                      ; generate a bootp request
#else
    ret
#endif
;+
; **-unknown-ip-unknown ip address packet handler.
;
; called from network when packet isn't for us - check for bootp
; reply packet.
;-

import_unknown_ipaddr:
    rcall pcode
;
; not quite yet!  see if it is to UDP:255.255.255.255:68 - which might be a
; BOOTP reply packet for us.  ip address is in buf.
;
    .dw pcmpwi,buf,0xffff       ; 255.255
    .dw pjumpne,drop_it          ; not broadcast
    .dw pcmpwi,buf+2,0xffff     ; .255.255
    .dw pjumpne,drop_it          ; not broadcast
;
; OK - it's to the correct address, how about the proto - is it UDP? 
;
	.dw pr2s,buf,IPH+8,2			; get TTL (buf) and proto (buf+1)
    .dw pcmpbi,buf+1,0x11       ; check if UDP
    .dw pjumpne,drop_it          ; sorry - not UDP
;
; UDP, check the port.
;
    .dw pr2s,buf,UDP_DP,2        ; get destination port
    .dw pcmpwi,buf,BSWAP(BOOTP_REPLY_PORT)  ; check if to bootp port
    .dw pjumpeq,bootp_reply      ; smells good - let BOOTP.ASM handle it
drop_it:    .dw 0
    ret
