;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

.eseg
.org 0x8000+CGI_INDEX_BASE

;
; top two bits set in length indicate CGI.  actually the length is not
; really used except for the flags.  up to the CGI code to return on its
; own!
;-
#define CGI(X) .dw X,(X##_end-X)|(0x8000+0x4000)    ; flags as CGI
#define CGI_BEGIN(X) X##:
#define CGI_END(X) X##_end:
#define putchar_serial .dw pmovbi,putc_b,0
#define putchar_net    .dw pmovbi,putc_b,1
#define serial_binary  .dw pser_mode,1
#define serial_normal  .dw pser_mode,0
#define showword(x)    .dw pprintv|XX,0,WORD(x)
#define BAUD           (UBRR+0x20)  /* mem addr of baud rate divisor */
#define B2400           207
#define B4800           103
#define B9600           51
#define B19200          25
#define SERTEST_BAUD    B9600
#define SER_TMO         800

cgi_table:
    .dw (cgi_table_end-cgi_table)/4
    CGI(cgi00)				; iu00
    CGI(cgi01)				; iu01
    CGI(sertest)			; iu02
    CGI(time_from_server)	; iu03
#ifdef ANSWERMAN
    CGI(answerman_all)      ; iu04
#else
#ifdef PANAMETRICS
    CGI(panametrics)	    ; iu04
#else
    CGI(cginull)	    ; iu04
#endif
    CGI(temp_top)           ; iu05
    CGI(temp_bottom)        ; iu06
    CGI(set_point)          ; iu07
    CGI(setpoint_finger)    ; iu08
#ifdef PANAMETRICS
    CGI(panametrics_dump)   ; iu09
#else
#ifdef RCS
    CGI(rcs_dump)	    ; iu09
#else
    CGI(cginull)	    ; iu09
#endif
#endif
#ifdef PANAMETRICS
    CGI(panametrics_stop)   ; iu0a
    CGI(pana_form)          ; iu0b
#else
#ifdef RCS
    CGI(rcs_stat)	    ; iu0a
    CGI(rcs_get_temp)	    ; iu0b
    CGI(rcs_setpt)	    ; iu0c
    CGI(rcs_mode_O)	    ; iu0d
    CGI(rcs_mode_H)	    ; iu0e
    CGI(rcs_mode_C)	    ; iu0f
    CGI(rcs_mode_A)	    ; iu10
    CGI(rcs_fan_0)	    ; iu11
    CGI(rcs_fan_1)	    ; iu12
    CGI(rcs_form)	    ; iu13
#else
    CGI(cginull)	    ; iu0a
#endif
#endif
cgi_table_end:

;+
; **-cginull-dummy.
;-

CGI_BEGIN(
    cginull
)
    .dw pret
CGI_END(cginull)

;+
; **-cgi00-testor.
;-

CGI_BEGIN(
    cgi00
)
    .dw pmovbi,BAUD,B19200              ; 19.2KB
    serial_normal                       ; temporary kludge
    .dw pprint,ehtml_header
    .dw pprint,ereset_msg   ;;eestring ereset_msg "Serial reset.\n"
    .dw pret
CGI_END(cgi00)

;+
; **-temperature-show the temperature in decimal.
;-
CGI_BEGIN(
    cgi01
)
    .dw pcall,tempf_buf
    .dw pcall,update_heater
    .dw pjump,decconv                   ; convert to decimal ascii
CGI_END(cgi01)
;+
; **-sertest-serial I/O testor.
;-

CGI_BEGIN(
    sertest
)
    .dw pmovbi,BAUD,SERTEST_BAUD
    .dw pprint,ehtml_header
;;eestring ehtml_header "HTTP/1.0 200\nContent-type: text/html\n\n"
    putchar_serial                      ; switch putchar to serial port
    .dw pmovwi|XX,buf,WORD(data_addr)   ; get data address
    .dw paddwi,buf,10                   ; GET /iu02?X
    .dw pmovwi|XX,buf+2,WORD(data_len)
sertest_next:
    .dw pr2s|XX,buf+4,WORD(buf),1       ; get next byte
    .dw pandwi,buf+4,0xff
    .dw pcmpwi,buf+4,'.'
    .dw pjumpeq,serial_done
    .dw pputcb,buf+4
    .dw paddwi,buf,1                    ; bump data address
    .dw psubwi,buf+2,1
    .dw pjumplo,serial_done
    .dw pjumpne,sertest_next
serial_done:
    .dw pmovbi,buf,0x0d
    ;
    ; come here with request char in buf.
    ;
serial_request:
    .dw pmovwi,buf+4,SER_TMO            ; select the timeout period
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    serial_normal
    serial_binary                       ; put serial port in binary mode
    putchar_serial                      ; switch putchar to serial port
    .dw pputcb,buf                      ; output to serial port
    putchar_net                         ; switch putchar back to 'net
;
; loop reading chars from the serial buffer and writing to 'net until
; there are no more characters.
;
    .dw pmovwi|XX,buf+2,WORD(buf+4)     ; timeout
    .dw pcall,fsertest
#if 0
    .dw pprint,edone_msg                ;;eestring edone_msg "\nLost="
    .dw phexbi|XX,BYTE(com_lost)
#endif
    .dw pret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.cseg

fsertest:
;
; buf+4 (word) = timeout loop count, and buf+2 is already loaded with
; that timeout value.
;
sertest_nextchar:
    .dw pser_getc,buf                   ; get a char into buf
    .dw pjumpeq,sertest_empty           ; no more chars!
    .dw pputcb,buf                      ; put char to the net
    .dw pmovwi|XX,buf+2,WORD(buf+4)     ; timeout
    .dw pjump,sertest_nextchar          ; go get another one
sertest_empty:
    .dw psubwi,buf+2,1                  ; decrement timeout
    .dw pjumpne,sertest_nextchar        ; not yet timed out
    .dw pret

.eseg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CGI_END(sertest)

CGI_BEGIN(
    time_from_server
)
    .dw pmovbi,buf,'T'                  ; time request
    .dw pjump,serial_request            ; get time from server
CGI_END(time_from_server)

#ifdef RCS
.dseg
;;;#define RCS_BAUD B19200            ; temporary for testing
#define RCS_BAUD B9600
#define RCSLEN  64
rcs_mode: .byte   1
rcs_fan: .byte   1
rcs_ptr: .byte   2
rcs_buf: .byte   RCSLEN
#define rcsp    buf
.eseg

CGI_BEGIN(
    rcs_stat
)
    .dw pcall,rcs_status	; get device status into buffer
    .dw pret
.eseg
CGI_END(rcs_stat)

CGI_BEGIN(
    rcs_form
)
    .dw pcall,rcs_form_check	; check for FORM URL
    .dw pret
.eseg
CGI_END(rcs_form)

.cseg
rcs_form_check:
    .dw pwdr             		; reset watchdog timer
    .dw pmovwi,rcs_ptr,buf+2		; process GET command
rcs_form_check_more:
    .dw pcmpwi|XX,rcs_ptr,buf+buf_len-1
    .dw pjumpeq,rcs_form_check_done

    .dw pmovb|XX,buf,BYTE(rcs_ptr)	; get next URL character
    .dw pcmpbi|XX,buf,' '		;  stop at first ' '
    .dw pjumpeq,rcs_form_check_done

    .dw pcmpbi|XX,buf,'U'		; look for 'U'
    .dw pjumpne,rcs_form_check_noU
    .dw pcall,rcs_form_set		; found! process form
    .dw pjumpeq,rcs_form_check_done

rcs_form_check_noU:
    .dw paddwi,rcs_ptr,1
    .dw pjump,rcs_form_check_more

rcs_form_check_done:
    .dw pret

rcs_form_set:
#if 1
    .dw pmovbi,BAUD,RCS_BAUD		; set serial port baud rate
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    serial_normal			; flush buffer (normal->binary does it)
    serial_binary                       ; put serial port in binary mode
    putchar_serial			; switch output to serial port
#endif

    .dw pmovwi,rcs_ptr,buf+2		; convert GET to RCS SET command
rcs_form_set_more:
    .dw pwdr             		; reset watchdog timer
    .dw pcmpwi|XX,rcs_ptr,buf+buf_len-1
    .dw pjumpeq,rcs_form_set_done

    .dw pmovb|XX,buf,BYTE(rcs_ptr)	; get next URL character
    .dw pcmpbi|XX,buf,' '		;  stop at first ' '
    .dw pjumpeq,rcs_form_set_done

    .dw pcmpbi|XX,buf,'X'		;  stop at first 'X'
    .dw pjumpeq,rcs_form_set_done

    .dw pcmpbi|XX,buf,'U'		;  stop at first 'U'
    .dw pjumpeq,rcs_form_set_done

    .dw pcmpbi|XX,buf,'='		;  special processing after '='
    .dw pjumpne,rcs_form_set_noeq
    .dw paddwi,rcs_ptr,1
    .dw pmovb|XX,buf,BYTE(rcs_ptr)	; get next URL character after '='
    .dw pcmpbi|XX,buf,'O'		; map 'O" to '0'
    .dw pjumpne,rcs_form_set_noO
    .dw pmovbi|XX,BYTE(rcs_ptr),'0'
rcs_form_set_noO:
    .dw pcmpbi|XX,buf,'H'		; map 'H" to '1'
    .dw pjumpne,rcs_form_set_noH
    .dw pmovbi|XX,BYTE(rcs_ptr),'1'
rcs_form_set_noH:
    .dw pcmpbi|XX,buf,'C'		; map 'C" to '2'
    .dw pjumpne,rcs_form_set_noC
    .dw pmovbi|XX,BYTE(rcs_ptr),'2'
rcs_form_set_noC:
    .dw pcmpbi|XX,buf,'A'		; map 'A" to '3'
    .dw pjumpne,rcs_form_set_noA
    .dw pmovbi|XX,BYTE(rcs_ptr),'3'
rcs_form_set_noA:
    .dw paddwi,rcs_ptr,-1		; restore URL pointer
    .dw pmovb|XX,buf,BYTE(rcs_ptr)	; restore next URL character

rcs_form_set_noeq:
    .dw pcmpbi|XX,buf,'&'		; map '&" to ','
    .dw pjumpne,rcs_form_set_noamp
    .dw pmovbi|XX,BYTE(rcs_ptr),','

rcs_form_set_noamp:
    .dw pputcb|XX,BYTE(rcs_ptr)
    .dw paddwi,rcs_ptr,1
    .dw pjump,rcs_form_set_more

rcs_form_set_done:
    .dw pmovbi|XX,BYTE(rcs_ptr),0x0d	; trailing CR
    .dw pputcb|XX,BYTE(rcs_ptr)
    putchar_net                         ; switch putchar back to 'net
    .dw pret
    .dw pprint,rcs_vect_msg                ;;eestring rcs_vect_msg "<META HTTP-EQUIV="REFRESH" CONTENT="0;\nURL=ii01">\n"
.eseg

CGI_BEGIN(
    rcs_get_temp
)
    putchar_net		; redirect output to 'net
    .dw pmovwi,rcs_ptr,rcs_buf            ; point to start of status buffer
    .dw paddwi,rcs_ptr,15		; "A=00 O=1 Z=1 T=74 SP=80 M=O FM=0\n"
    .dw pputcb|XX,WORD(rcs_ptr)
    .dw paddwi,rcs_ptr,1                 ; advance pointer
    .dw pputcb|XX,WORD(rcs_ptr)
    .dw pret
.eseg
CGI_END(rcs_get_temp)

CGI_BEGIN(rcs_mode_O)
    .dw pmovwi,rcs_mode,'O'
    .dw pcall,rcs_mode_X
    .dw pret
CGI_END(rcs_mode_O)

CGI_BEGIN(rcs_mode_H)
    .dw pmovwi,rcs_mode,'H'
    .dw pcall,rcs_mode_X
    .dw pret
CGI_END(rcs_mode_H)

CGI_BEGIN(rcs_mode_C)
    .dw pmovwi,rcs_mode,'C'
    .dw pcall,rcs_mode_X
    .dw pret
CGI_END(rcs_mode_C)

CGI_BEGIN(rcs_mode_A)
    .dw pmovwi,rcs_mode,'A'
    .dw pcall,rcs_mode_X
    .dw pret
CGI_END(rcs_mode_A)

; <input type="radio" value="{rcs_mode}"[ checked] name="M">
.cseg
rcs_mode_X:
    putchar_net		; redirect output to 'net
    .dw pprint,rcs_mode_s1  ;;eestring rcs_mode_s1 "<input type="radio" value=""
    .dw pputcb|XX,rcs_mode
    .dw pprint,rcs_mode_s2  ;;eestring rcs_mode_s2 """

    .dw pmovwi|XX,buf,WORD(rcs_mode)    ; target value?
    .dw pcmpbi|XX,buf,BYTE(rcs_buf+26) ; "A=00 O=1 Z=1 T=74 SP=80 M=O FM=0\n"
    .dw pjumpne,rcs_mode_nochk
    .dw pprint,rcs_mode_s3  ;;eestring rcs_mode_s3 " checked"

rcs_mode_nochk:
    .dw pprint,rcs_mode_s4  ;;eestring rcs_mode_s4 " name="M">"
    .dw pret
.eseg

CGI_BEGIN(rcs_fan_0)
    .dw pmovwi,rcs_fan,'0'
    .dw pcall,rcs_fan_X
    .dw pret
CGI_END(rcs_fan_0)

CGI_BEGIN(rcs_fan_1)
    .dw pmovwi,rcs_fan,'1'
    .dw pcall,rcs_fan_X
    .dw pret
CGI_END(rcs_fan_1)

; <input type="radio" value="{rcs_fan}"[ checked] name="F">
.cseg
rcs_fan_X:
    putchar_net		; redirect output to 'net
    .dw pprint,rcs_fan_s1  ;;eestring rcs_fan_s1 "<input type="radio" value=""
    .dw pputcb|XX,rcs_fan
    .dw pprint,rcs_fan_s2  ;;eestring rcs_fan_s2 """

    .dw pmovwi|XX,buf,WORD(rcs_fan)    ; target value?
    .dw pcmpbi|XX,buf,BYTE(rcs_buf+31) ; "A=00 O=1 Z=1 T=74 SP=80 M=O FM=0\n"
    .dw pjumpne,rcs_fan_nochk
    .dw pprint,rcs_fan_s3  ;;eestring rcs_fan_s3 " checked"

rcs_fan_nochk:
    .dw pprint,rcs_fan_s4  ;;eestring rcs_fan_s4 " name="F">"
    .dw pret
.eseg

CGI_BEGIN(
    rcs_setpt
)
    putchar_net		; redirect output to 'net
    .dw pmovwi,rcs_ptr,rcs_buf            ; point to start of status buffer
    .dw paddwi,rcs_ptr,21		; "A=00 O=1 Z=1 T=74 SP=80 M=O FM=0\n"
    .dw pputcb|XX,WORD(rcs_ptr)
    .dw paddwi,rcs_ptr,1                 ; advance pointer
    .dw pputcb|XX,WORD(rcs_ptr)
    .dw pret
.eseg
CGI_END(rcs_setpt)

CGI_BEGIN(
    rcs_dump
)
    .dw pcall,rcs_status	; get device status

    .dw pmovwi,rcsp,rcs_buf	; dump entire response buffer to 'net
rcsnext:
    .dw pcmpwi|XX,rcsp,WORD(rcs_ptr)
    .dw pjumpeq,rcsshow_done
    .dw pputcb|XX,WORD(rcsp)
    .dw paddwi,rcsp,1
    .dw pjump,rcsnext
rcsshow_done:
    .dw pret

.cseg
rcs_status:		; get status of RCS temp unit
    .dw pmovbi,BAUD,RCS_BAUD		; set serial port baud rate
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    serial_normal			; flush buffer (normal->binary does it)
    serial_binary                       ; put serial port in binary mode
    putchar_serial			; switch output to serial port
    .dw pwdr             		; reset watchdog timer
    .dw pprint,rcs_query  ;;eestring rcs_query "A=1,R=1\r"
    putchar_net				; redirect output back to 'net
    .dw pcall,rcsin			; get response from external device
    .dw pret

rcsin:
    .dw pmovwi,buf+2,SER_TMO           ; reset timeout counter
    .dw pwdr             		; reset watchdog timer
    .dw pmovwi,rcs_ptr,rcs_buf            ; point to start of buffer
rcsnextchar:
    .dw pser_getc,buf                   ; get a char into buf
    .dw pjumpeq,rcsempty               ; no more chars!
    .dw pcmpbi,buf,0x0d			; exit on first CR
    .dw pjumpeq,rcsdone
    .dw pmovbi|XX,WORD(rcs_ptr),BYTE(buf)    ; save next byte
    .dw paddwi,rcs_ptr,1                 ; advance pointer
    .dw pcmpwi,rcs_ptr,rcs_buf+RCSLEN     ; check if reached limit
    .dw pjumpeq,rcsdone                ; sorry - ran out of space
    .dw pmovwi,buf+2,SER_TMO           ; reset timeout counter
    .dw pwdr             		; reset watchdog timer
    .dw pjump,rcsnextchar              ; go get another one
rcsempty:
    .dw psubwi,buf+2,1                  ; decrement timeout
    .dw pjumpne,rcsnextchar            ; not yet timed out
rcsdone:
    .dw pret

.eseg
CGI_END(rcs_dump)
#endif /* RCS */

#ifdef PANAMETRICS
.dseg
//#define PANA_BAUD B19200   ; serial port baud rate (testing)
#define PANA_BAUD B9600   ; serial port baud rate
#define PANA_SER_TMO 20000  ; serial read timeout loop count
#define PANA_LEN  64
pana_stop_ch:	.byte   1
pana_flush:	.byte   1
pana_ptr: .byte   2
pana_buf: .byte   PANA_LEN

.eseg

CGI_BEGIN(
    panametrics_stop
)
    .dw pmovbi,BAUD,PANA_BAUD	; set serial port baud rate
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    serial_normal			; flush buffer (normal->binary does it)
    serial_binary                       ; put serial port in binary mode
    putchar_serial			; switch output to serial port
    .dw pputc,'#'			; send out '#'
    putchar_net				; redirect output back to 'net
    .dw pret
CGI_END(panametrics_stop)

CGI_BEGIN(
    panametrics_dump
)
;
; loop reading chars from the serial buffer and writing to 'net until
; there are no more characters.
;
    .dw pmovbi,pana_stop_ch,0xff
    .dw pcall,pana_in
    .dw pret

CGI_END(panametrics_dump)

CGI_BEGIN(
    panametrics
)
;
; loop reading chars from the serial buffer and writing to 'net until
; end of first line
;
    .dw pmovbi,pana_stop_ch,0x0a
    .dw pcall,pana_in
    .dw pret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.cseg

pana_in:
    ;
    ; going from normal to binary mode flushes the buffer.
    ;
    serial_normal
    serial_binary                       ; put serial port in binary mode
    ;
    ; switch to serial port so we can slam out the request.
    ;
    putchar_serial
    .dw pprint,panametrics_query  ;;eestring panametrics_query "t"
    ;
    ; now back to the 'net so we can output the bytes.
    ;
    putchar_net
;
; buf+4 (word) = timeout loop count, and buf+2 loaded with
; that timeout value, buf+6 (byte) is last char input
;
    .dw pmovbi,BAUD,PANA_BAUD
    .dw pmovwi,buf+2,PANA_SER_TMO
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    .dw pmovbi,pana_flush,0             ; don't flush characters
    .dw pmovwi,buf+6,0			; reset "last char"

pana_nextchar:
    .dw pser_getc,buf                   ; get a char into buf
    .dw pjumpeq,pana_empty               ; no more chars!

    .dw pcmpbi|XX,buf,BYTE(pana_stop_ch) ; stop character?
    .dw pjumpne,pana_cr_chk
    .dw pmovbi,pana_flush,1             ; start flushing characters

pana_cr_chk:
    .dw pcmpbi,buf,0x0d			; CR?
    .dw pjumpeq,pana_skip

    .dw pcmpbi,buf,0x0a			; double newline?
    .dw pjumpne,pana_space
    .dw pcmpbi,buf+6,0x0a
    .dw pjumpeq,pana_done		; yes...exit

pana_space:
    .dw pcmpbi,buf,' '			; double space?
    .dw pjumpne,pana_output
    .dw pcmpbi,buf+6,' '
    .dw pjumpeq,pana_skip		; yes...skip output

pana_output:
    .dw pmovwi|XX,buf+6,WORD(buf)	; save last character
    .dw pcmpbi,pana_flush,1		; flushing output?
    .dw pjumpeq,pana_skip		; yes...skip output
    .dw pputcb,buf			; output byte

pana_skip:
    .dw pmovwi,buf+2,PANA_SER_TMO ; reset timeout
    .dw pwdr             		; reset watchdog timer
    .dw pjump,pana_nextchar              ; go get another one

pana_empty:
    ;;;;.dw phexbi|XX,BYTE(buf+2)  ;;;;;;;;;;;;;;;!!!!!!!!!!!!!;;;;;;;
    .dw psubwi,buf+2,1                  ; decrement timeout
    .dw pjumpne,pana_nextchar            ; not yet timed out
    .dw pprint,pana_to   ;;eestring pana_to "[No gauge present]\n"
pana_done:
    .dw pret

.eseg

CGI_END(panametrics)

CGI_BEGIN(
    pana_form
)
    .dw pcall,pana_form_check	; check for FORM URL
    .dw pret

.cseg
pana_form_check:
    .dw pwdr             		; reset watchdog timer
    .dw pmovwi,pana_ptr,buf+2		; process GET command
pana_form_check_more:
    .dw pcmpwi|XX,pana_ptr,buf+buf_len-1 ; off end of buffer?
    .dw pjumpeq,pana_form_check_done	; yep...exit

    .dw pmovb|XX,buf,BYTE(pana_ptr)	; get next URL character
    .dw pcmpbi|XX,buf,' '		;  stop at first ' '
    .dw pjumpeq,pana_form_check_done	; exit

    .dw pcmpbi|XX,buf,'K'		; look for 'K='
    .dw pjumpne,pana_form_check_noKeq	; nope...
    .dw paddwi,pana_ptr,1		; get next URL character
    .dw pmovb|XX,buf,BYTE(pana_ptr)
    .dw paddwi,pana_ptr,-1		; restore pointer
    .dw pcmpbi|XX,buf,'='		; check for '='
    .dw pjumpne,pana_form_check_noKeq	; nope...

    .dw paddwi,pana_ptr,2		; found! point to char after '='
#if 1
    .dw pmovbi,BAUD,PANA_BAUD		; set serial port baud rate
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    serial_normal			; flush buffer (normal->binary does it)
    serial_binary                       ; put serial port in binary mode
    putchar_serial			; switch output to serial port
#endif
    .dw pputcb|XX,BYTE(pana_ptr)	; send character to unit
    putchar_net                         ; switch putchar back to 'net
    .dw pjumpeq,pana_form_check_done	; exit

pana_form_check_noKeq:
    .dw paddwi,pana_ptr,1		; bump URL pointer
    .dw pjump,pana_form_check_more	; back for next URL character

pana_form_check_done:
    .dw pret

.eseg
CGI_END(pana_form)
#endif /* PANAMETRICS */

#ifdef ANSWERMAN
.dseg
#define ANSWERMAN_BAUD B9600            ; temporary for testing
#define ANSLEN  40
ansptr: .byte   2
ansbuf: .byte   ANSLEN
#define ansp    buf
.eseg

CGI_BEGIN(
    answerman_all
)
    .dw pmovbi,BAUD,ANSWERMAN_BAUD
    .dw pmovwi,ansptr,ansbuf            ; point to start of buffer
    .dw pmovwi,buf+4,SER_TMO
    .dw pmovwi,buf+2,WORD(buf+4)
    .dw pmovbi,com_lost,0               ; zero out lost char counter
    ;
    ; going from normal to binary mode flushes the buffer.
    ;
    serial_normal
    serial_binary                       ; put serial port in binary mode
    ;
    ; switch to serial port so we can slam out the request.
    ;
    putchar_serial
    ;
    ; the leading \r appears to be necessary when the baud rate has just
    ; changed (like first thing after reboot when the baud rate is at 19.2
    ; and ANSWERMAN_BAUD is 9600).
    ;
    .dw pprint,answerman_query  ;;eestring answerman_query "\r! MAN0 QE\r"
    ;
    ; now back to the 'net so we can output the bytes.
    ;
    putchar_net
;
; loop reading chars from the serial buffer and writing to 'net until
; there are no more characters.
;
    .dw pcall,ans_in

    .dw pmovwi,ansp,ansbuf
ansp_next:
    .dw pcmpwi|XX,ansp,WORD(ansptr)
    .dw pjumpeq,ans_show_done
    .dw pputcb|XX,WORD(ansp)
    .dw paddwi,ansp,1
    .dw pjump,ansp_next
ans_show_done:
    .dw pret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.cseg

ans_in:
;
; buf+4 (word) = timeout loop count, and buf+2 is already loaded with
; that timeout value.
;
ans_nextchar:
    .dw pser_getc,buf                   ; get a char into buf
    .dw pjumpeq,ans_empty               ; no more chars!
    .dw pcmpbi,buf,0x0a
    .dw pjumpeq,ans_done
    .dw pmovbi|XX,WORD(ansptr),BYTE(buf)    ; save next byte
    .dw paddwi,ansptr,1                 ; advance pointer
    .dw pcmpwi,ansptr,ansbuf+ANSLEN     ; check if reached limit
    .dw pjumpeq,ans_done                ; sorry - ran out of space
    .dw pmovwi|XX,buf+2,WORD(buf+4)     ; timeout
    .dw pjump,ans_nextchar              ; go get another one
ans_empty:
    .dw psubwi,buf+2,1                  ; decrement timeout
    .dw pjumpne,ans_nextchar            ; not yet timed out
ans_done:
    .dw pret

.eseg

CGI_END(answerman_all)
#endif /* ANSWERMAN */

;+
; **-decconv-decimal converter.
;
; inputs:
;   buf = word to convert
;
; outputs:
;   result printed (with pputc)
;
; caveats:
;   MUST be called with pcall!!
;-
#define DIG_BUF buf+6
#define DIG_PTR buf+4
#define DEC_REM buf+2
#define DEC_VAL buf

decconv:    .dw pmovwi,DIG_PTR,DIG_BUF         ; pcode_routine
    .dw pbitwi,DEC_VAL,0x8000           ; check the sign
    .dw pjumpeq,decconv1                ; positive - start conversion
    .dw pnegw,DEC_VAL                   ; negate it
    .dw pputc,'-'
decconv1:
    .dw pdiv|XX,DEC_VAL,WORD(DEC_VAL),10    ; get next one
    .dw paddwi,DEC_REM,'0'              ; convert digit for display
    .dw pmovbi|XX,WORD(DIG_PTR),BYTE(DEC_REM)  ; save digit
    .dw paddwi,DIG_PTR,1                ; bump past digit just stored
    .dw psubwi,DEC_VAL,0                ; test remaining value
    .dw pjumpne,decconv1                 ; if more to convert
decconv2:
    .dw psubwi,DIG_PTR,1                ; point to next one
    .dw pputcb|XX,BYTE(DIG_PTR)         ; show it
    .dw pcmpwi,DIG_PTR,DIG_BUF          ; check if just did last one
    .dw pjumpne,decconv2                 ; nope - do next one
    .dw pret

CGI_BEGIN(
    temp_top
)
    .dw pcall,tempf_buf
    .dw pcall,compute_top
    .dw pjump,decconv
CGI_END(temp_top)
compute_top:
    .dw pmovwi,buf+2,130
    .dw psubwi|XX,buf+2,WORD(buf)
    .dw pshnw,buf+2,1
    .dw pmovwi|XX,buf,WORD(buf+2)
    .dw pret
CGI_BEGIN(
    temp_bottom
)
    .dw pcall,tempf_buf
    .dw pshnw,buf,1
    .dw pjump,decconv
CGI_END(temp_bottom)

CGI_BEGIN(
    set_point
)
    .dw pr2s|XX,buf,WORD(data_addr),16
    .dw pcmpbi,buf+9,'?'            ; GET /iiNN?s=xx        ; we want xx
                                    ; 01234567890123
    .dw pjumpne,not_setting_setpoint
    .dw pclrw,buf
    .dw pclrw,buf+2
    .dw pmovbi|XX,buf,BYTE(buf+12)
    .dw psubwi,buf,'0'
    .dw pmul|XX,buf,WORD(buf),10    ; do first digit
    .dw pmovbi|XX,buf+2,WORD(buf+13)
    .dw psubwi,buf+2,'0'
    .dw paddwi|XX,buf,WORD(buf+2)
    .dw peeprom_write|XX,eeprom_setpt,BYTE(buf)
not_setting_setpoint:
    .dw pcall,get_setpoint
    .dw pjump,decconv
CGI_END(set_point)
get_setpoint:
    .dw pcall,update_heater
    .dw pclrw,buf
    .dw ee2s,buf,1,1
    .dw pret
#define CUR_TEMP buf
#define CUR_SETP buf+14
update_heater:
#if defined(ENABLE_HEATER)
    .dw pclrw,CUR_SETP
    .dw ee2s,CUR_SETP,1,1           ; get setpoint
    .dw pcall,tempf_buf             ; get temperature (into buf)
    .dw pcmpwi|XX,CUR_TEMP,WORD(CUR_SETP)  ; check temp against setpoint
    .dw pjumplo,heater_on
    .dw pmovbi,PORTD+0x20,1<<LED_BIT
#endif
    .dw pret
heater_on:
    .dw pmovbi,PORTD+0x20,0
    .dw pret
tempf_buf:
    .dw pclrw,buf
#if defined(TEMPERATURE_EEPROM)
    .dw ee2s,buf,TEMPERATURE_EEPROM,1   ; read temperature (C) to buf
#else
    .dw pread_temp,buf                  ; get temp
#endif
    .dw pmovwi,buf+4,0x80              ; set up for sign test
    .dw pandwi|XX,buf+4,WORD(buf)       ; check the sign
    .dw pjumpeq,temp_positive            ; it is positive
    .dw pmovbi,buf+1,0xff              ; extend the sign
    .dw pnegw,buf                       ; negate
temp_positive:
    .dw pmul|XX,buf,WORD(buf),9         ; C*9
    .dw pdiv|XX,buf,WORD(buf),5         ; /5
    .dw pandwi,buf+4,0x80               ; test original sign
    .dw pjumpeq,temp_norenegate          ; positive
    .dw pnegw,buf
temp_norenegate:
    .dw paddwi,buf,32                   ; +32 - buf now has temp (F)
    .dw pret
CGI_BEGIN(
    setpoint_finger
)
    .dw pcall,get_setpoint
    .dw pcall,compute_top
    .dw psubwi,buf,3
    .dw pjump,decconv
CGI_END(setpoint_finger)
