# this thing takes the specified eep file and splits it into two
# files - one with everything below a specified boundary, the other
# with everything equal to or above the boundary.
#
# perl cgisplit.pl filebasename boundaryinhex
#
open(R,"<$ARGV[0].eep") || die "Can't open $ARGV[0].eep" ;
$eepic_name = "$ARGV[0].ep" ;
open(EEPIC,">$eepic_name") || die "Can't open $eepic_name" ;
open(SEEPROM,">$ARGV[0].el") || die "Can't open $ARGV[0].el" ;
binmode(SEEPROM) ;
$boundary = hex($ARGV[1]) ;
$last_seeprom = 0 ;
$OFFSET = 0x8000 ;		# seeprom offset for code space
while (<R>)  {
    (@x) = split(/:/) ;
    $addr = hex($x[0]) ;    # address
    if ($addr < 512)  { # pic EEPROM
        print EEPIC ;
        $keep_eepic = 1 ;
    }
    elsif ($addr > 512)  {  # not in PIC eeprom
        if (!$last_seeprom)  {	# first we've seen
            print SEEPROM pack("S",$addr-$OFFSET) ;
            $last_seeprom = $addr ;
            printf STDERR "SEEPROM base %04X\n",$addr ;
        }
        if ($addr == $last_seeprom)  {
            print SEEPROM pack("C",hex($x[1])) ;
            $last_seeprom++ ;
        }
        else  {
            printf STDERR "Missing data @ %04X-%04X\n",$last_eeprom,$addr ;
            exit(3) ;
        }
    }
}
close(R) ;
close(EEPIC) ;
if (!$keep_eepic)  {
   unlink($eepic_name) ;
}
close(SEEPROM) ;
