;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

import_cli_exec:
cli_exec:       export

	clr r20			; default to bad command
	sts cmd_ok,r20

	rcall pcode
#include "cmd.inc"
	.dw 0

	lds r20,cmd_ok		; command OK?
	cpi r20,0
	brne cli_exec_ok
	putchar '?'

cli_exec_ok:
	ret

import_do_outstr:
do_outstr:      export
	pop	zh		; z = (sp)+
	pop	zl
	lsl	zl
	rol	zh		; convert return address to data pointer
	lpm
	ori zl,1
	mov	r1,r0
	lpm			; [r0:r1] = pointer to string (already *2)
	adiw	zl,1
	shrw z
	push	zl
	push	zh		; put incremented return addr back on stack
	mov	zl,r1
	mov	zh,r0
nextchar:
	lpm
	adiw	zl,1		; advance pointer to next byte
	tst	r0
	breq	outstrdone
	mov	ch,r0
	rcall	do_putchar	; slam it out
	rjmp	nextchar
outstrdone:
	ret

do_outstrs:
nextchars:
	ld	i0,y+
	tst	i0
	breq	outstrdones
	mov	ch,i0
	rcall	do_putchar	; slam it out
	rjmp	nextchars
outstrdones:
	ret
;+
; **-dumpsram-dump sram in hex.
;-

dump_sram:
	movwi z,readb_y
dumpx:
#if 0
	push	yl
	push	yh
	push	ch
	push	i0
	push	r21
	push	r22
#endif
#if 0
	ldsw	y,cmdop1
	ldsw	r21,cmdop2
	cpi	r22,0		; no more than 128!
	brne	dumpsr0		; branch if MSB non-zero
	sbrc	r21,7		; skip if bit 7 of LSB clear
dumpsr0:
	ldi	r21,0x80
	addw	r21,y
dumpsr1:
#else
	ldsw	y,cmdop1
	ldsw	r21,cmdop2
	cpi	r22,0		; no more than 128!
	brne	dumpsr0		; branch if MSB non-zero
	sbrs	r21,7		; skip if bit 7 of LSB set
	rjmp	dumpsr3
dumpsr0:
	;;;;;;;clr	r22		; limit count
	;;;;;;ldi	r21,0x80
	movwi	r21,512
dumpsr3:
	addw	r21,y
dumpsr1:
#endif
	mov	ch,yl
	andi	ch,0x0f
	brne	dumpsr2
	crlf
	rcall	hexy
dumpsr2:
	space
	pushw z
	icall
	popw z
	hexb
	cp	yl,r21
	brne	dumpsr1
	cpc	yh,r22
	brlt	dumpsr1
	crlf
#if 0
	pop	r22
	pop	r21
	pop	i0
	pop	ch
	pop	yh
	pop	yl
#endif
	ret

readb_y:
	ld i0,y+
	ret
pcode_debug_toggle: lds yl,cmdop1
    sts pcode_debug_flag,yl
    ret
;+
; **-dump_eeprom-dump eeprom.
;-

dump_eeprom:
	movwi z,eeprom_read
	rjmp dumpx
;+
; **-dump_seeprom-dump seeprom.
;-

dump_seeprom:
	movwi z,seeprom_read
	rjmp dumpx
;+
; **-do_pcode_call-do a pcode call (pcall)
;
; inputs:
;   cmdop1  = word containing address to call (no checking!!!)
;
; outputs:
;   who knows!!
;-

do_pcode_call:
    pushw p
    rcall pcode
    .dw pcall|XX,WORD(cmdop1)
    .dw 0
#if defined(PCODE_DEBUG)
    putchar '>'
    popw y
    rcall hexy
    pushw y
#endif
    popw p
    ret
;+
; **-hexcvtb-hex convert byte.
;
; inputs:
;       x -> buffer
;
; outputs:
;       i0  = byte value
;       x   = x + 2
;-

hexcvtb:            export
	push r16
	push i1

	clr i0			; default to zero
	ld r16,x+               ; get next byte
	rcall h2nib		; convert it
	ld r16,x+               ; get next byte
	rcall h2nib

	pop i1
	pop r16
	ret

#if 1
;+
; **-hexcvtw-hex convert word.
;
; inputs:
;       x -> buffer
;
; outputs:
;       i0,i1  = word value
;       x      = point to next character < '0'
;-

hexcvtw:
	push r16

	clr i0			; default to zero
	clr i1
h2w0:
	ld r16,x		; get next nibble

	cpi r16,'0'
	brlt h2wx       	; <'0'...time to exit
	incw x			; bump x
	rcall h2nib		; convert nibble in r16
	rjmp h2w0
h2wx:
	pop r16
	ret

h2nib:
	cpi r16,('9'+1)
	brge h2w1               ; not a number - must be a-f or a-f

	subi r16,'0'
	rjmp h2w2
h2w1:
	andi r16,7              ; a-f/A-F becomes 1-6 (a=61, A=41)
	subi r16,-9             ; x--9 == x+9, 1 becomes 0x0a
h2w2:
	lsl r16			; shift to upper nibble
	lsl r16
	lsl r16
	lsl r16

	push r17
	ldi r17,4
h2w3:
	rol r16
	rol i0
	rol i1
	dec r17
	brne h2w3
	pop r17
	ret
#endif
;+
; **-hexmem_x-hex dump of memory.
;
; inputs:
;       x   = starting address
;       r16 = byte count
;
; outputs:
;       x   = advanced beyond bytes printed
;       r16 = 0
;-

hexmem_x:
	space
	ld i0,x+
	hexb
	dec r16
	brne hexmem_x
	ret
;+
; **-pspace-pcode output a space.
;
; outputs:
;   outputs a single space (0x20) via equivalent of pputc.
;-

pspace: pcode_routine 0
do_space:
	push ch
	putchar ' '
	pop ch
	ret
;+
; **-pputcb-pcode putchar byte.
;
;   r10 -> byte to output
;-

pputcb:  pcode_routine 1
	movw x,r10
	ld ch,x+
	rjmp do_putchar
;+
; **-pputc-pcode putchar equivalent.
;
; inputs:
;   r10l    = character to output
;   putc_b  = control flag 0=output to serial port, else -> transmit stream.
;
; outputs:
;   byte written to serial port, or to transmit stream, or stored in
;   holding buffer pending flush of transmit buffer.
;-

pputc:  pcode_routine 1
	mov ch,r10
	rjmp do_putchar
#ifdef ENABLE_isa_rloop
isa_rloop:
	mov r16,yl
	mov i0,r16
	hexb          ; show what byte
read1:
	rcall isa_in
	rjmp read1
#endif

#ifdef ENABLE_isa_tloop
isa_tloop:
	setport EN_CCMD,ENC_NODMA+ENC_PAGE1 ;       +ENC_STOP
	ldi r16,EN1_PHYS
	ldi r20,0x55
	ldi r17,6   ; ether size
lt1:
	mov i0,r20
	inc r20
	rcall isa_out
	inc r16 ; advance port
	dec r17
	brne lt1
	ret
#endif

#ifdef ENABLE_isa_wloop
isa_wloop:
	mov r16,yl
	mov i0,r20l
write1:
	rcall isa_out
	rjmp write1
#endif

#ifdef ENABLE_sram_write
sram_write:
	st y,r20
	ret
#endif

neon_toggle:
	lds r17,neon
	com r17
	sts neon,r17
	rjmp showtoggle

log_toggle:
	lds r17,nelog
	com r17
	sts nelog,r17
showtoggle:
	mov i0,r17
	hexb
	ret

#ifdef ENABLE_dump_net_header
dump_net_header:
	movw r20,y	; get address into r20
	rcall ne_getheader
	movwi x,rcv_hdr
	movwi r16,hdr_size
	rcall hexmem_x
	ret
#endif

#ifdef ENABLE_board_write
board_write:
	movw r20,y	; get address into r20
	movwi r18,hdr_size  ; write as much as a header is
	clrw y            ; we'll write y
	movwi z,wb1         ; data provider
	rcall ne_wstart
	ret
wb1:
	incw y
	mov i0,yl
	mov i1,i0
	com i1
	rjmp hexy
#endif

#ifdef ENABLE_board_dump
board_dump:
	movwi r20,0x4600        ; start at first receive buffer
	movwi r18,(SM_RSTOP_PG<<8)-(SM_RSTART_PG<<8)
	movwi z,bdd1
	rcall ne_rstart         ; start transfer
	ret
#endif

bdd1:
#ifdef ENABLE_WATCHDOG
	wdr             ; reset watchdog timer
#endif
	tstbi r18l,0x1f         ; check if time for new line
	brne bdd2
	crlf
	movw y,r20
	rcall hexy
	space
bdd2:
	hexb
	mov i0,i1
	hexb             ; byte mode
	addwi r20,1
	ldi w,0x1f
	and w,r20l
	cpi w,0x10
	brne bdd3
	space
bdd3:
	ret

#if 1
;;
;; ethernet register disgnostic
;;
ea_reg_diag:
	clr r17
	sts	nch,r17
	sts	ready,r17
	setport en_ccmd,enc_nodma+enc_page1

ea_reg_diag_1:

	ldi r17,6
	ldi r16,1		; starting at port 1
next_ea_1:
	mov i0,r17
	rcall    isa_out
	inc r16
	dec r17
	brne next_ea_1

	ldi r17,6
	ldi r16,1		; starting at port 1
next_ea_2:
	rcall    isa_in
	space
	hexb
	inc r16
	dec r17
	brne next_ea_2
	crlf

	lds	w,ready
	tst	w
	breq	ea_reg_diag_1            ; if CR not yet pressed...

	rcall iosweep

	setport en_ccmd,enc_nodma+enc_page0
	ret
#endif

import_iosweep:
iosweep:
	setport en_ccmd,enc_nodma+enc_page0
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page1
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page2
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page3
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page0
	ret
iosweep1:
;;
;; sweep the possible I/O space - see what's out there!
;;
	ldi r17,16              ; was 32 - but don't do it now for NE2000
	                        ; because upper ports if read without conditioning for
	                        ; transfer cause problems on REAL ISA bus - why???
	clr r16                 ; starting at port 0
nextboard:
	rcall    isa_in
	space
	hexb
	inc r16
	dec r17
	brne nextboard
	crlf
	ret
;
;   p-code command checker
;
;   r10 = 1- or 2-byte command code
;   r12 = routine to call if command codes match
;
pchk_cmd:  pcode_routine 2
	movw r18,r10		; move target command bytes to r18
	movwi x,inbuf		; move input buffer pointer to x
	ld r16,x+		; get first character of input command buffer
	cp r16,r18		; match with command?
	brne chk_cmd_exit	; no...exit
	cpi r19,0		; yes...more command bytes?
	breq chk_cmd_1		; no...execute command
	ld r16,x+		; get second character of input command buffer
	cp r16,r19		; match with command?
	brne chk_cmd_exit	; no...exit
chk_cmd_1:
	sts cmd_ok,r18		; show good command
	incw x			; skip character
	rcall hexcvtw		; get next hex word from command buffer
	sts cmdop1,i0		; save as LSB of address
	sts cmdop1+1,i1		; save as MSB of address

	incw x			; skip character
	rcall hexcvtw		; get next hex word from command buffer
	mov r20,i0		; r20/21 = parameter #2
	mov r21,i1		;
	sts cmdop2,i0		; save as LSB of count/word
	sts cmdop2+1,i1		; save as MSB of count/word

	ldsw y,cmdop1		; y = parameter #1
	movw z,r12		; call routine
	icall
#if defined(PCODE_DEBUG)
    popw y
    putchar 'R'
    rcall hexy
    pushw y
#endif
chk_cmd_exit:
	ret

#ifdef ENABLE_zap_sram
zap_sram:		; y has first parameter
	movwi x,0x60	; base of SRAM
	movwi r18,512	; size
	mov r20,yl	; we'll write this value everywhere
zap_sram1:
	st x+,r20
	decw r18
	brne zap_sram1
	rjmp RESET	; reset processor
#endif


show_ether:                     ; display ethernet address
    putchar 'e'
    putchar 'a'
    putchar ' '
    putchar '='
    movwi   x,my_ether
    ldi r16,6
    rjmp hexmem_x
