#
#  cmd2asm.pl - convert PicoWeb command table to assembly language
#
#
#    Sample command table:
#
#     ws   poke_seeprom
#     we   poke_eeprom
#     dr   dump SRAM
#     de   dump EEPROM
#     ds   dump serial EEPROM
#
$args = "@ARGV";
$line_num = 0;
while (<>) {
	$line = $_;
	$line =~ s/[\r\n]+$//;
	$line =~ s/^[\s\t]+//;
	next if ($line =~ /^$/);
	$org_line = $line;
	$line =~ s/[;].*//;
	++$line_num;
	next if ($line =~ /^\s*[#]/);
	$n = @fld = split(/[\s\n]+/, $line);
	if ($n != 2) {
		print STDERR "$0($line_num): Bad input '$line'\n";
		next;
	}
	$cmd = $fld[0];
	$routine = $fld[1];
	$cmds{$cmd} = $routine;
	++$routines{$routine};
}

print <<EOF;
;;;;;;;;;;;;;;;;;;;;;; DO NOT EDIT THIS FILE!!! ;;;;;;;;;;;;;;;;;;;;;
;
;   AUTOMATICALLY GENERATED from: $0 $args
;
;;;;;;;;;;;;;;;;;;;;;; DO NOT EDIT THIS FILE!!! ;;;;;;;;;;;;;;;;;;;;;
EOF
for ($i = 0; $i < 15; ++$i) {
	print "\n";
}

foreach $routine (sort{$b cmp $a;} (keys(%routines))) {
	print "#define ENABLE_$routine\n";
}
print "\n";

print ";\n";
print "; command dispatch table\n";
print ";\n";
foreach $cmd (sort{$b cmp $a;} (keys(%cmds))) {
	$routine = $cmds{$cmd};
	$ch1 = ord(substr($cmd, 0, 1));
	$ch2 = ord(substr($cmd, 1, 1));
	##print ";\t$cmd\t$routine ($ch1, $ch2)\n";
	printf("\t.dw pchk_cmd,0x%04x,%-20s ; %s\n", ($ch2 << 8) | $ch1, $routine, $cmd);
}
print "\n";
