;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

//#define SEEPROM_IP      (0x4000-4)  /* seeprom IP address */
//#define USE_BOOTP
#define EEPROM_IP eeprom_ip_addr       /* get ip address from eeprom */
#define DEBUGGER

//#define STATIC_IP_MSB 0xc0f5    /* static IP 192.245.227.127 */
//#define STATIC_IP_LSB 0xe37f    /* static IP 192.245.227.127 */

#define BREADBOARD
#ifdef BREADBOARD
#define LED_BIT 0           /* bit in port D controlling user LED */
#else
#define LED_BIT 4           /* bit in port D controlling user LED */
#define ENABLE_HEATER
#define BYTEWIDE_DBUS
#endif

//#define ANSWERMAN	/* Micromint Answerman connected to serial port */

//#define PANAMETRICS	/* Panametrics 26DL Plus connected to serial port */
#ifdef PANAMETRICS
#undef DEBUGGER
#endif

//#define RCS		/* RCS temp controller connected to serial port */
#ifdef RCS
#undef DEBUGGER
#endif

#define CGI_INDEX_BASE  0x3800  /* SEEPROM base of CGI index */
#define URL_IN_EEPROM
//#define TEMPERATURE_EEPROM  1   /* eeprom address for temp */
#define SEELOAD_DEBUG
//#define PCODE_NOOPT       /* turns off register opt in pcode.asm */
//#define PCODE_DEBUG
//#define SIMULATOR
//#define TEST_PCODE
#define NELOG_INITIALLY_ON
//#define PROMISCUOUS
#define WTS_ALWAYS
//#define ICMP_DEBUG
//#define TCP_DEBUG             /* static debug */
//#define     TCP_HEADER_DEBUG    /* runtime-enablable header debug */
//#define TCP_LOGGING_INITIALLY_ON    /* enable runtime header debug */
//#define   TCP_CHECKSUM_ON_THE_FLY
//#define   TCP_PROCESS_ACKS
#define TCPPORT_CMD 911         /* command line port */
//#define TCP_GET_DEBUG
//#define RECV_DEBUG
#define RESET_ON_RCV_OVR	/* reset chip on certain buffer overruns */
//#define RECV_OVERRUN_DEBUG
#define ENABLE_WATCHDOG		/* enable watchdog timer */
#define PKT_WATCHDOG_MAX 250	/* max. idle net timer loops before reset
#define PKT_WATCHDOG_DEBUG
#define SHOW_ETHER_ADDRESS_ON_BOOT
//#define R2X_DEBUG
//#define R2S_DEBUG
//#define OTHER_PKT_DEBUG   /* packets not destined for me are logged */
//#define XMIT_DEBUG
#define WAIT_TXDONE
//#define REWRITE_CURPAG
#define BOOTP_DEBUG
//#define BOOTP_DISABLED
#define TIMING_DISABLED
//#define   FLASH_IMAGES    /* jpg/gif in flash */
//#define RSADDR_DEBUG
//#define RSCNT_DEBUG

//#define NE_RSTART_OLD_WAY
//#define R2X_OLD_WAY

//#define TIME_ICMP
#define I2C_PORT1_PRESENT

#define SER_EEPROM_BASE_ADDR    0xA0	/* 24LC128 128K-bit serial EEPROM */
#define DS1621_BASE_ADDR    	0x9E	/* ext. DS1621 digital thermometer */

#ifdef TIME_ICMP
#define ENABLE_TIMER_ROUTINES
#endif

/*
 * for now, as far as we can tell, TCP_EXTENDED MUST BE DEFINED - otherwise
 * remote connections end up in LAST_ACK state.
 */
#define TCP_EXTENDED      /* extended TCP functions - like ACK processing! */
#define WINDOW_SIZE 8192    /* fixed window size */

.equ XX = 0x8000                        ; eXtended operand fetching
.equ XW = 0x4000                        ; word mode, else byte
.equ XS = 0x2000                        ; swap bytes

#define BYTE(x) (XX|(x))
#define WORD(x) (XX|XW|(x))
#define SWAP(x) (XX|XS|(x))
