# images.pl - build the eeprom images.
#
# this takes an input and an output file and processes all images in the
# input file into an EEPROM image in the specified output file.
#
# this goes along with the code in URL.ASM which assumes that EEPROM location
# 0000 contains the base of the image directory.
#
$debug = 0 ;
$MAX_BYTES = 1402 ;   # Max. payload of Ethernet GET response packet
open(IMGF,$ARGV[0]) || die "Can't open image list '$ARGV[0]'" ;
open(OUT,">$ARGV[1]") || die "Can't create output file $ARGV[1]" ;
binmode(OUT) ;
$imgdir = "" ;
$imgdata = "" ;
$numimages = 0 ;
$imgloc = 0 ;
if (open(V,"<version"))  {
    $_ = scalar(<V>) ;
    ($version=$_) =~ s/[\r\n\.]+// ;
    close(V) ;
}
$image_number = 0 ;
while (<IMGF>)  {
    ($file,$x) = split(/\s/) ;
    $images{$image_number} = $file ;
    $image_name_to_number{$file} = sprintf("%02X",$image_number) ;
    $image_number++ ;
}
$number_of_images = $image_number ;
for ($image_number=0 ; $image_number < $number_of_images ; $image_number++)  {
    $file = $images{$image_number} ;
    if ($file =~ /\.jpg/i)  {
        $flag = 0 ;
    }
    elsif ($file =~ /\.gif/i)  {
        $flag = 0x8000 ;
    }
    elsif ($file =~ /\.html/i)  {
    	$flag = 0x4000 ;
    }
    else  {
        print STDERR "Ignored $file\n" ;
        next ;              # not an image we know, blow it off
    }
    $name = $file ;
    open(F,"<$file") || die "Can't open $file" ;
    binmode(F) ;
    sysread(F,$str,16384) ; # haul in the whole thing
    if (($len = length($str)) > $MAX_BYTES) {
        print "Warning! Truncating '$file' from $len to $MAX_BYTES bytes!\n" ;
        $str = substr($str, 0, $MAX_BYTES) ;
    }
    if ($flag == 0x4000)  {
        $str =~ s/[\r]//g ;
        $str =~ s/[\n]/\r/g ;
        while ($str =~ s/\r\/\/[^\r]*\r/\r/g) { ; } # simple // comments
        ##$str =~ s/([^:])\/\/[^\r]*\r/$1\r/g ; # simple // comments
        $str =~ s/\$\$VERSION\$\$/$version/g ;
        $str =~ s/(\"[^\"]+\")/&nametonum($1)/eg ;
        $str =~ s/[\r]/\n/g ;
	##print "\n-------------\n$str";
        $str .= pack("C",0) ;   # make sure HTML has a trailing NUL
        print $str if ($debug);
    }
    $imgdata .= $str ;      # append the data
    printf STDOUT "%02X $name\n",$numimages ;
    $offsets{$numimages} = $imgloc ;
    $lengths{$numimages} = length($str) ;
    $flags{$numimages} = $flag ;
    $numimages++ ;
    $imgloc += length($str) ;
    close(F) ;
}
$imgdir = pack("S",$numimages) ;    # # of images
$imgbase = 2+($numimages*4) ;       # first location
print "$numimages images\n" if ($debug);

for ($i=0 ; $i<$numimages ; $i++)  {
    $imgdir .= pack("SS",$offsets{$i}+$imgbase,$lengths{$i}|$flags{$i}) ;
    if ($debug) {
        print "$i:\t$offsets{$i}+$imgbase, $lengths{$i} | $flags{$i}\n";
        printf("\t%04x, %04x | %04x\n",
            $offsets{$i}+$imgbase, $lengths{$i}, $flags{$i});
    }
}
$imgdir .= $imgdata ;
if (syswrite(OUT,$imgdir,length($imgdir)) != length($imgdir))  {
    die "Can't write output length ",length($imgdir),"\n" ;
}
close(OUT) ;

sub nametonum  {
    local($name) = @_ ;

    $name =~ s/\"//g ;
    if (defined $image_name_to_number{$name})  {
        print "Mapped image $name to #",$image_name_to_number{$name},"\n" if ($debug);
        return "\"ii".$image_name_to_number{$name}."\"" ;
    }
    else  {
        print "skipping '$name'\n" if ($debug) ;
        return "\"$name\"" ;
    }
}
