#! /usr/local/perl
#
#  Convert IP static address (dot notation) to "define.h"/"ip.inc"
#

sub usage {
	print STDERR "usage: $ego [-v] [-define] [-bat] x.y.z.w\n";
	print STDERR "       $ego [-v] [-define] [-bat] - < file\n";
	exit 1;
}

$ego = $0;
$ego =~ s/.*[\/\\]//;

$define = 0;
$bat = 0;
$verbose = 0;
while ($ARGV[0] =~ /^-/ && $ARGV[0] ne '-') {
	$opt = shift;
	if ($opt eq '-define') {
		$define = 1;
	} elsif ($opt eq '-bat') {
		$bat = 1;
	} elsif ($opt eq '-v') {
		$verbose = 1;
	} else {
		&usage;
	}
}

$ip = shift;
&usage if ($ip eq '');

exit(1) if (($ip = &getip($ip)) eq '');

(@a) = split(/\./,$ip) ;
$ip = sprintf("%d.%d.%d.%d", $a[0], $a[1], $a[2], $a[3]);

if ($define) {
	printf("#define STATIC_IP_MSB 0x%02x%02x\t/* static IP $ip */\n", $a[0], $a[1]);
	printf("#define STATIC_IP_LSB 0x%02x%02x\n", $a[2], $a[3]);
} elsif ($bat) {
	print "set PIC=$ip\n";
} else {
	printf("\t.db\t0x%02x\t; IP $ip\n", $a[0]);
	printf("\t.db\t0x%02x\n", $a[1]);
	printf("\t.db\t0x%02x\n", $a[2]);
	printf("\t.db\t0x%02x\n", $a[3]);
}
print STDERR "$ip\n" if ($verbose);

#
#  Resolve IP address
#  usage: exit(1) if (($ip = &getip($ip)) eq '');
#         where $s is IP address, '-', or @file
#
sub getip {
	local($f) = @_;

	$ip = '';
	if ($f =~ /^[@]/ || $f eq '-') {
		if ($f ne '-') {
			$f =~ s/^[@]//;
			if (!open(IP, "<$f")) {
				print STDERR "Can't open IP address file \"$f\"!\n";
				return '';
			}
		}
		while(1) {
			if ($f ne '-') { $s = <IP>; } else { $s = <>; }
			##print "$s";
			last if ($s eq '');
			if ($s =~ /^\s*(\d+[.]\d+[.]\d+[.]\d+)[\r\n\s]*$/) {
				$ip = $1;
			}
		}
	} else {
		$ip = $f;
	}
	if ($ip =~ /^\d+[.]\d+[.]\d+[.]\d+$/) {
		return $ip;
	} else {
		print STDERR "IP address ($ip) not of the form x.y.z.w!\n";
		return '';
	}
}
