#! /usr/local/perl
#
#   Load PicoWeb EEPROM using network
#
sub usage {
	print STDERR "usage: $ego IPaddress EEPROM_file\n" ;
	print STDERR "       $ego -url IPaddress URL\n" ;
	exit 1 ;
}

$ego = $0 ;
$ego =~ s/^.*[\/\\]// ;
&usage if ($ARGV[0] eq '') ;

$status = 0 ;
$url = '' ;
select((select(STDOUT), $| = 1)[0]);    # unbuffer output

if ($ARGV[0] eq '-url') {
	shift ;
	$url = $ARGV[1] ;
}
exit(1) if (($ip = &getip($ARGV[0])) eq '');
&usage if ($ARGV[2] ne '') ;

if ($url) {
    $cmd = "httpget -t 10 $ip$url" ;
    system($cmd) ;
    exit(0) ;
}

&do_open ;
open(F,"<$ARGV[1]") || die "Can't open $ARGV[1]" ;
binmode(F) ;
$addr = 0 ;
if ($ARGV[1] =~ /\.el/i)  {
    sysread(F,$buf,2) ;
    $addr = unpack("S",$buf) ;  # starting address
}
$blocksize = $ARGV[2] ;
$blocksize = 192 if ($blocksize == 0) ; # 256-4-6-6-2-20-20-2(length)
#
# blocksize can still be specified, but it better be a multiple of
# the page size in serial eeprom (64 bytes) - otherwise page wrap will
# occur, and the results will not be favorable!
#
while (sysread(F,$buf,$blocksize) > 0)  {
     if (length($buf) != $blocksize)  {  # truncate
        close(I) ;
        &do_open ;
    }
    seek(I,0,0) ;
    syswrite(I,pack("S",$addr),2) ;
    syswrite(I,$buf,length($buf)) ;
    $cmd = "httpget -rP img.tmp -t 10 $ip:611" ;
    ##printf "%04X ",$addr ;
    ##system($cmd) ;
    $s = `$cmd` ;
    if ($s =~ /^\s+[0-9a-fA-F]+/) {
        print "." ;
    } else {
        $status = 1 ;
    }
    $addr += length($buf) ;
}
close(I) ;
unlink("img.tmp") ;
print "\n";
exit $status ;

sub do_open  {
    if (!open(I,">img.tmp")) {
         print STDERR "Can't create img.tmp!\n" ;
         exit 1;
    }
    binmode(I) ;
    select(I) ;
    $| = 1 ;
    select(STDOUT) ;
    $| = 1 ;
}
#
#  Resolve IP address
#  usage: exit(1) if (($ip = &getip($ip)) eq '');
#         where $s is IP address, '-', or @file
#
sub getip {
	local($f) = @_;

	$ip = '';
	if ($f =~ /^[@]/ || $f eq '-') {
		if ($f ne '-') {
			$f =~ s/^[@]//;
			if (!open(IP, "<$f")) {
				print STDERR "Can't open IP address file \"$f\"!\n";
				return '';
			}
		}
		while(1) {
			if ($f ne '-') { $s = <IP>; } else { $s = <>; }
			##print "$s";
			last if ($s eq '');
			if ($s =~ /^\s*(\d+[.]\d+[.]\d+[.]\d+)[\r\n\s]*$/) {
				$ip = $1;
			}
		}
	} else {
		$ip = $f;
	}
	if ($ip =~ /^\d+[.]\d+[.]\d+[.]\d+$/) {
		return $ip;
	} else {
		print STDERR "IP address ($ip) not of the form x.y.z.w!\n";
		return '';
	}
}
