;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

#include "define.h"
#include "8515def.inc"
#include "8390.inc"
#include "sdfmac.inc"
#include "isa.inc"
#include "timing.inc"
#include "tcpip.inc"

.macro export
.endmacro

.device	AT90S8515	;Prohibits use of non-implemented instructions
.def	ch	    = r25           ; character for putchar - also a temp (w1)

.equ	stackend = ramend

#define TCPPORT_CMD 911         /* command line port */

; interrupt vectors.

	rjmp	RESET		;Reset Handle
	rjmp	int0_isr
	rjmp	int1_isr
	rjmp	timer1cap_isr
	rjmp	timer1compa_isr
	rjmp	timer1compb_isr
	rjmp	timer1ovf_isr
	rjmp	timer0ovf_isr
	rjmp	spistc_isr
	rjmp	rx_isr
	rjmp	udre_isr
	rjmp	tx_isr
	rjmp	ana_comp_isr

.include "picbin.inc"

#if !defined(LOG_UNKNOWN_INTERRUPTS)
int0_isr:
int1_isr:
timer1cap_isr:
timer1compa_isr:
timer1compb_isr:
timer1ovf_isr:
timer0ovf_isr:
spistc_isr:
udre_isr:
tx_isr:
ana_comp_isr:
	putchar	'?'
	putchar	'?'
	rjmp	reset
#else
int0_isr:
	ldi	r24,'0'
	rjmp	force_reset
int1_isr:
	ldi	r24,'1'
	rjmp	force_reset
timer1cap_isr:
	ldi	r24,'2'
	rjmp	force_reset
timer1compa_isr:
	ldi	r24,'3'
	rjmp	force_reset
timer1compb_isr:
	ldi	r24,'4'
	rjmp	force_reset
timer1ovf_isr:
	ldi	r24,'5'
	rjmp	force_reset
timer0ovf_isr:
	ldi	r24,'6'
	rjmp	force_reset
spistc_isr:
	ldi	r24,'7'
	rjmp	force_reset
udre_isr:
	ldi	r24,'8'
	rjmp	force_reset
tx_isr:
	ldi	r24,'9'
	rjmp	force_reset
ana_comp_isr:
	ldi	r24,'a'
	rjmp	force_reset

force_reset:
	in	yl,spl		; save SP
	in	yh,sph

	ldi	w,low(stackend)	; set up stack (in case blown!)
	out	spl,w
	ldi	w,high(stackend)
	out	sph,w
	putchar	'?'
	mov	ch,r24
	rcall	do_putchar
	putchar	'?'

	putchar	'S'
	hexy			; print SP
	crlf

	movwi	r21,0x60	; dump all registers
	clr	yl
	clr	yh
	movwi	z,readb_y
	rcall	dumpsr3
	movwi	r21,512		; dump all sram
	rcall	dumpsr3
	crlf

	ldi	r16,0x08	; enable watchdog
	out	wdtcr,r16
here:	rjmp	here		; wait for watchdog timer

#endif

;***** Code

RESET:
	clr r17
	out	sreg,r17
	out gimsk,r17		; disable INT0/INT1
	out mcucr,r17
    sts serial_mode,r17
	sts ccaddr,r17
	sts ccaddr+1,r17
    sts pcode_debug_flag,r17
#if !defined(NELOG_INITIALLY_ON)
	sts nelog,r17
#endif
#ifdef PKT_WATCHDOG_DEBUG
	sts pkt_wdogs,r17	; zero packet watchdog debug counter
#endif

	ser r17
;    	sts pcode_debug_flag,r17	;; !!!! force pcode debug !!!!

	sts neon,r17                ; turn on ne2000 driver
#if defined(NELOG_INITIALLY_ON)
	sts nelog,r17
#endif
;;;;;;;;;;;;;;;;;  control-C comes here...
reset1:
#ifdef ENABLE_WATCHDOG
	ldi r16,0x0F	; enable watchdog timer (~2 sec.)
	out wdtcr,r16
	wdr		; reset watchdog timer
#endif
	clr r17
	sts xoff,r17				; not xoffed
	sts putc_b,r17              ; putchar is "normal"
#ifdef PKT_WATCHDOG_MAX
	sts pkt_wdog_cnt,r17	; zero packet watchdog counter
#endif

; initialize SP to top of SRAM.

	ldi	w,low(stackend)
	out	spl,w
	ldi	w,high(stackend)
	out	sph,w
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;; DO NOT DO ANY [R]CALL instructions before this point! ;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	rcall   i2c_init
	sbi     ddrd,LED_BIT

#ifdef ENABLE_TIMER_ROUTINES
; set up 16-bit timer (assumes other timer control regs are zero!)
	ldi	r17,0x02	; clock with CPU clock/8
	out	tccr1b,r17 
	zero_timer		; zero timer
#endif

; set serial port baud rate.

	ldi	r17,25              	; 9600 Baud with a 4Mhz clock
	out	UBRR,r17

; enable transmitter and receiver, and enable receiver interrupts.

 	ldi	r17,(1<<rxcie)|(1<<rxen)|(1<<txen)
	out	UCR,r17

; enable global interrupts.

	ldi	r17,0x80
	out	sreg,r17
    sei

#ifdef I2C_PORT1_PRESENT
; start temperature conversion
	ldi	yl,0xEE
	rcall	ds1621_write
#endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#if defined(SIMULATOR)
	clr r17
#else
	ser r17
#endif
	sts putcok,r17                  ; turn on putchar
	ldi r18l,4                      ; 4 bytes

#if defined(STATIC_IP_MSB)
;
; use static IP assignment
;
	movwi x,my_ip
	movwi y,STATIC_IP_MSB
	st x+,yh
	st x+,yl
	movwi y,STATIC_IP_LSB
	st x+,yh
	st x+,yl
#else
#if defined(EEPROM_IP) || defined(SEEPROM_IP)
;
; get ip address from eeprom/seeprom.
;
	movwi x,my_ip
#if defined(EEPROM_IP)
	movwi y,EEPROM_IP
	rcall eeprom_read_bytes
#endif
#if defined(SEEPROM_IP)
	movwi y,SEEPROM_IP
	rcall seeprom_read_bytes
#endif
#else
#define USE_BOOTP
	movwi x,my_ip
	clr r0
zero_ip:
	st x+,r0
	dec r18l
	brne zero_ip
#endif
#endif
#ifdef DEBUGGER
	outstr hello ;;string hello "\r\nFrey'nHell-Light PicoWeb v$$VERSION$$"
#endif

	rcall pcode_init                ; initialize pcode engine
	rcall network_init

#ifdef DEBUGGER
#define SHOW_ETHER_ADDRESS_ON_BOOT
#ifdef SHOW_ETHER_ADDRESS_ON_BOOT
	crlf
	ldi r17,6
	putchar 'e'
	putchar 'a'
	putchar '='
	movwi x,my_ether
show_ether1:
	ld i0,x+
	hexb
	dec r17
	brne show_ether1
#endif
#endif

#if defined(USE_BOOTP)
	rcall bootp                     ; generate a BOOTP request
#endif

#ifdef ENABLE_TIMER_ROUTINES
	clr r0
	sts timer,r0
	sts timer+1,r0
	sts timer+2,r0                  ; reset the timer

	show_timer			; show 16-bit timer
	zero_timer			; zero timer
#endif

	ldsw yl,ccaddr			        ; show PC (from ^C interrupt)
	mov r0,yl
	or r0,yh
	breq doprompt
	crlf
	putchar '@'
	rcall hexy

doprompt:

#ifdef DEBUGGER
	outstr prompt                   ;;string prompt "\r\n# "
#endif
	clr r17
	sts	nch,r17
	sts	ready,r17
;
; command loop - wait for CR, call ne2000 handler.
;
loop:
;
; this counter wraps about every 1.5 seconds on an 8515/4 with the current
; processing load.  SDF 1998/11/15.
;
#ifdef ENABLE_WATCHDOG
	wdr		; reset watchdog timer
#endif
	clr r0
	ldi r17,1
	lds r16,timer
	add r16,r17
	sts timer,r16
	lds r16,timer+1
	adc r16,r0
	sts timer+1,r16
	brcc loop1
	; the timer has counted down.
#if defined(USE_BOOTP)
	rcall bootp_timer
#endif
#if defined(ENABLE_HEATER)
	rcall check_heater
#endif
#ifdef PKT_WATCHDOG_MAX
	lds r17,neon
	or r17,r17
	breq no_pkt_wdog

	lds r17,pkt_wdog_cnt	; bump/check net watchdog
	inc r17
	sts pkt_wdog_cnt,r17
	cpi r17,PKT_WATCHDOG_MAX
	brne no_pkt_wdog

#ifdef PKT_WATCHDOG_DEBUG
	lds r17,pkt_wdogs	; bump debug counter
	inc r17
	sts pkt_wdogs,r17
#endif
	rcall network_init	; reset network chip

	clr r17
	sts pkt_wdog_cnt,r17    ; zero packet watchdog counter
no_pkt_wdog:
#endif

loop1:
;
; check if NE2000 code is enabled, if so, set logging flag based on nelog, and
; call NE2000 logic, then enable logging.
;
	lds r17,neon
	or r17,r17
	breq ne_off

	lds r17,nelog
	sts putcok,r17          ; enable/disable output based on nelog flag

	rcall network

	ser r17
	sts putcok,r17          ; turn output back on

ne_off:
;
; if no command, keep looping.
;
	lds	w,ready
	tst	w
	breq	loop            ; if CR not yet pressed...
;;
;; there is a command in the input buffer, nul-terminate it.
;;
	ldsbw z,nch
	addwi z,inbuf
	ldi	r17,0
	st	z,r17               ; nul-terminate
;;
;; process command.
;;
	crlf
	rcall cli_exec
	rjmp doprompt
;+
; **-udp_recv-udp receive handler.
;-

import_udp:
    ret

;+
; **-pwdr-pcode watchdog reset.
;
; inputs:
;	none
;-

pwdr:	pcode_routine	0
#ifdef ENABLE_WATCHDOG
	wdr		; reset watchdog timer
#endif
	ret

.eseg
.org 1
#ifndef BREADBOARD
eeprom_ether:
#include "ether.inc"
#endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;; any/all user EEPROM data MUST follow ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#ifdef EEPROM_IP
eeprom_ip_addr:
#include "ip.inc"
#endif

eeprom_setpt:	.db 70          ; default temperature setpoint
.cseg

#if defined(ENABLE_HEATER)
check_heater:
    rcall pcode
    .dw ee2s,buf,511,1
    .dw pandwi,buf,0xff
    .dw pjumpne,no_update_heater
    .dw pcall,update_heater
no_update_heater:
    .dw 0
#endif
#if !defined(USE_BOOTP)
import_unknown_ipaddr:
#endif
    ret

#include "serial.asm"

#if defined(USE_BOOTP)
#include "bootp.asm"
#endif

#include "cmd.asm"
#include "cgipcode.asm"
#include "url.asm"

.cseg
.include "picweb.asi"
.eseg
.include "picweb.esi"
