#line 1 "picweb.asm"
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

#line 1 "define.h" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

//#define SEEPROM_IP      (0x4000-4)   
//#define USE_BOOTP



//#define STATIC_IP_MSB 0xc0f5     
//#define STATIC_IP_LSB 0xe37f     










//#define ANSWERMAN	 

//#define PANAMETRICS	 




//#define RCS		 






//#define TEMPERATURE_EEPROM  1    

//#define PCODE_NOOPT        
//#define PCODE_DEBUG
//#define SIMULATOR
//#define TEST_PCODE

//#define PROMISCUOUS

//#define ICMP_DEBUG
//#define TCP_DEBUG              
//#define     TCP_HEADER_DEBUG     
//#define TCP_LOGGING_INITIALLY_ON     
//#define   TCP_CHECKSUM_ON_THE_FLY
//#define   TCP_PROCESS_ACKS

//#define TCP_GET_DEBUG
//#define RECV_DEBUG

//#define RECV_OVERRUN_DEBUG







//#define XMIT_DEBUG

//#define REWRITE_CURPAG

//#define BOOTP_DISABLED

//#define   FLASH_IMAGES     
//#define RSADDR_DEBUG
//#define RSCNT_DEBUG

//#define NE_RSTART_OLD_WAY
//#define R2X_OLD_WAY

//#define TIME_ICMP









 






.equ XX = 0x8000                        ; eXtended operand fetching
.equ XW = 0x4000                        ; word mode, else byte
.equ XS = 0x2000                        ; swap bytes




#line 7 "picweb.asm" 2

#line 1 "8515def.inc" 1
;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number		:AVR000
;* File Name		:"8515def.inc"
;* Title		:Register/Bit Definitions for the AT90S8515
;* Date                 :97.12.11
;* Version              :1.20
;* Support telephone	:+47 72 88 87 20 (ATMEL Norway)
;* Support fax		:+47 72 88 87 18 (ATMEL Norway)
;* Support E-mail	:avr@atmel.com
;* Target MCU		:AT90S8515
;*
;* DESCRIPTION
;* When including this file in the assembly program file, all I/O register	
;* names and I/O register bit names appearing in the data book can be used.
;* In addition, the six registers forming the three data pointers X, Y and
;* Z have been assigned names XL - ZH. Highest RAM address for Internal 
;* SRAM is also defined 
;*
;* The Register names are represented by their hexadecimal address.
;* 
;* The Register Bit names are represented by their bit number (0-7).
;* 
;* Please observe the difference in using the bit names with instructions
;* such as "sbr"/"cbr" (set/clear bit in register) and "sbrs"/"sbrc" 
;* (skip if bit in register set/cleared). The following example illustrates
;* this:
;* 
;* in	r16,PORTB		;read PORTB latch
;* sbr	r16,(1<<PB6)+(1<<PB5)	;set PB6 and PB5 (use masks, not bit#)
;* out  PORTB,r16		;output to PORTB
;*
;* in	r16,TIFR		;read the Timer Interrupt Flag Register
;* sbrc	r16,TOV0		;test the overflow flag (use bit#)
;* rjmp	TOV0_is_set		;jump if set
;* ...				;otherwise do something else
;***************************************************************************

;***** Specify Device
.device AT90S8515

;***** I/O Register Definitions
.equ	SREG	=$3f
.equ	SPH	=$3e
.equ	SPL	=$3d
.equ	GIMSK	=$3b
.equ	GIFR	=$3a
.equ	TIMSK	=$39
.equ	TIFR	=$38
.equ	MCUCR	=$35
.equ	TCCR0	=$33
.equ	TCNT0	=$32
.equ	TCCR1A	=$2f
.equ	TCCR1B	=$2e
.equ	TCNT1H	=$2d
.equ	TCNT1L	=$2c
.equ	OCR1AH	=$2b
.equ	OCR1AL	=$2a
.equ	OCR1BH	=$29
.equ	OCR1BL	=$28
.equ	ICR1H	=$25
.equ	ICR1L	=$24
.equ	WDTCR	=$21
.equ	EEARH	=$1f
.equ	EEARL	=$1e
.equ	EEDR	=$1d
.equ	EECR	=$1c
.equ	PORTA	=$1b
.equ	DDRA	=$1a
.equ	PINA	=$19
.equ	PORTB	=$18
.equ	DDRB	=$17
.equ	PINB	=$16
.equ	PORTC	=$15
.equ	DDRC	=$14
.equ	PINC	=$13
.equ	PORTD	=$12
.equ	DDRD	=$11
.equ	PIND	=$10
.equ	SPDR	=$0f
.equ	SPSR	=$0e
.equ	SPCR	=$0d
.equ	UDR	=$0c
.equ	USR	=$0b
.equ	UCR	=$0a
.equ	UBRR	=$09
.equ	ACSR	=$08


;***** Bit Definitions
.equ	INT1	=7
.equ	INT0	=6

.equ	TOIE1	=7
.equ	OCIE1A	=6
.equ	OCIE1B	=5
.equ	TICIE1	=3
.equ	TOIE0	=1

.equ	TOV1	=7
.equ	OCF1A	=6
.equ	OCF1B	=5
.equ	ICF1	=3
.equ	TOV0	=1

.equ	SRE	=7
.equ	SRW	=6
.equ	SE	=5
.equ	SM	=4
.equ	ISC11	=3
.equ	ISC10	=2
.equ	ISC01	=1
.equ	ISC00	=0

.equ	COM1A1	=7
.equ	COM1A0	=6
.equ	COM1B1	=5
.equ	COM1B0	=4
.equ	PWM11	=1
.equ	PWM10	=0

.equ	ICNC1	=7
.equ	ICES1	=6
.equ	CTC1	=3
.equ	CS12	=2
.equ	CS11	=1
.equ	CS10	=0

.equ	WDTOE	=4
.equ	WDE	=3
.equ	WDP2	=2
.equ	WDP1	=1
.equ	WDP0	=0

.equ	EEMWE	=2
.equ	EEWE	=1
.equ	EERE	=0

.equ	PA7	=7
.equ	PA6	=6
.equ	PA5	=5
.equ	PA4	=4
.equ	PA3	=3
.equ	PA2	=2
.equ	PA1	=1
.equ	PA0	=0

.equ	DDA7	=7
.equ	DDA6	=6
.equ	DDA5	=5
.equ	DDA4	=4
.equ	DDA3	=3
.equ	DDA2	=2
.equ	DDA1	=1
.equ	DDA0	=0

.equ	PINA7	=7
.equ	PINA6	=6
.equ	PINA5	=5
.equ	PINA4	=4
.equ	PINA3	=3
.equ	PINA2	=2
.equ	PINA1	=1
.equ	PINA0	=0

.equ	PB7	=7
.equ	PB6	=6
.equ	PB5	=5
.equ	PB4	=4
.equ	PB3	=3
.equ	PB2	=2
.equ	PB1	=1
.equ	PB0	=0

.equ	DDB7	=7
.equ	DDB6	=6
.equ	DDB5	=5
.equ	DDB4	=4
.equ	DDB3	=3
.equ	DDB2	=2
.equ	DDB1	=1
.equ	DDB0	=0

.equ	PINB7	=7
.equ	PINB6	=6
.equ	PINB5	=5
.equ	PINB4	=4
.equ	PINB3	=3
.equ	PINB2	=2
.equ	PINB1	=1
.equ	PINB0	=0

.equ	PC7	=7
.equ	PC6	=6
.equ	PC5	=5
.equ	PC4	=4
.equ	PC3	=3
.equ	PC2	=2
.equ	PC1	=1
.equ	PC0	=0

.equ	DDC7	=7
.equ	DDC6	=6
.equ	DDC5	=5
.equ	DDC4	=4
.equ	DDC3	=3
.equ	DDC2	=2
.equ	DDC1	=1
.equ	DDC0	=0

.equ	PINC7	=7
.equ	PINC6	=6
.equ	PINC5	=5
.equ	PINC4	=4
.equ	PINC3	=3
.equ	PINC2	=2
.equ	PINC1	=1
.equ	PINC0	=0

.equ	PD7	=7
.equ	PD6	=6
.equ	PD5	=5
.equ	PD4	=4
.equ	PD3	=3
.equ	PD2	=2
.equ	PD1	=1
.equ	PD0	=0

.equ	DDD7	=7
.equ	DDD6	=6
.equ	DDD5	=5
.equ	DDD4	=4
.equ	DDD3	=3
.equ	DDD2	=2
.equ	DDD1	=1
.equ	DDD0	=0

.equ	PIND7	=7
.equ	PIND6	=6
.equ	PIND5	=5
.equ	PIND4	=4
.equ	PIND3	=3
.equ	PIND2	=2
.equ	PIND1	=1
.equ	PIND0	=0

.equ	RXC	=7
.equ	TXC	=6
.equ	UDRE	=5
.equ	FE	=4
.equ	OR	=3

.equ	SPIE	=7
.equ	SPE	=6
.equ	DORD	=5
.equ	MSTR	=4
.equ	CPOL	=3
.equ	CPHA	=2
.equ	SPR1	=1
.equ	SPR0	=0

.equ	SPIF	=7
.equ	WCOL	=6

.equ	RXCIE	=7
.equ	TXCIE	=6
.equ	UDRIE	=5
.equ	RXEN	=4
.equ	TXEN	=3
.equ	CHR9	=2
.equ	RXB8	=1
.equ	TXB8	=0

.equ	ACD	=7
.equ	ACO	=5
.equ	ACI	=4
.equ	ACIE	=3
.equ	ACIC	=2
.equ	ACIS1	=1
.equ	ACIS0	=0

.def	XL	=r26
.def	XH	=r27
.def	YL	=r28
.def	YH	=r29
.def	ZL	=r30
.def	ZH	=r31

.equ 	RAMEND =$25F	;Last On-Chip SRAM Location

.equ	INT0addr=$001	;External Interrupt0 Vector Address
.equ	INT1addr=$002	;External Interrupt1 Vector Address
.equ	ICP1addr=$003	;Input Capture1 Interrupt Vector Address
.equ	OC1Aaddr=$004	;Output Compare1A Interrupt Vector Address
.equ	OC1Baddr=$005	;Output Compare1B Interrupt Vector Address
.equ	OVF1addr=$006	;Overflow1 Interrupt Vector Address
.equ	OVF0addr=$007	;Overflow0 Interrupt Vector Address
.equ	SPIaddr =$008	;SPI Interrupt Vector Address
.equ	URXCaddr=$009	;UART Receive Complete Interrupt Vector Address
.equ	UDREaddr=$00a	;UART Data Register Empty Interrupt Vector Address
.equ	UTXCaddr=$00b	;UART Transmit Complete Interrupt Vector Address
.equ	ACIaddr =$00c	;Analog Comparator Interrupt Vector Address
#line 8 "picweb.asm" 2

#line 1 "8390.inc" 1
; The EN registers - the DS8390 chip registers 
; There are two (really 3) pages of registers in the chip. You select 
; which page you want, then address them at offsets 00-0F from base. 
; The chip command register (EN_CCMD) appears in both pages. 
; EN_OFF is the offset from the board's base register to the EN registers. 
;
.equ eaddr_len = 6 ;               bytes in an ether address 
;
.equ en_ccmd = 0x000 ;      Chip's command register 
;
; Page 0 
;
.equ en0_cldalo = 0x001 ;  	 Low byte of current local dma addr  RD 
.equ en0_startpg = 0x001 ;  	 Starting page of ring bfr WR 
.equ en0_cldahi = 0x002 ;  	 High byte of current local dma addr  RD 
.equ en0_stoppg = 0x002 ;  	 Ending page +1 of ring bfr WR 
.equ en0_boundary = 0x003 ;  	 Boundary page of ring bfr RD WR 
.equ en0_tsr = 0x004 ;  	 Transmit status reg RD 
.equ en0_tpsr = 0x004 ;  	 Transmit starting page WR 
.equ en0_ncr = 0x005 ;  	 Number of collision reg RD 
.equ en0_tcntlo = 0x005 ;  	 Low  byte of tx byte count WR 
.equ en0_fifo = 0x006 ;  	 FIFO RD 
.equ en0_tcnthi = 0x006 ;  	 High byte of tx byte count WR 
.equ en0_isr = 0x007 ;  	 Interrupt status reg RD WR 
.equ en0_crdalo = 0x008 ;  	 low byte of current remote dma address RD 
.equ en0_rsarlo = 0x008 ;  	 Remote start address reg 0 
.equ en0_crdahi = 0x009 ;  	 high byte of current remote dma address RD 
.equ en0_rsarhi = 0x009 ;  	 Remote start address reg 1 
.equ en0_rcntlo = 0x00a ;  	 Remote byte count reg WR 
.equ en0_rcnthi = 0x00b ;  	 Remote byte count reg WR 
.equ en0_rsr = 0x00c ;  	 rx status reg RD 
.equ en0_rxcr = 0x00c ;  	 RX control reg WR 
.equ en0_txcr = 0x00d ;  	 TX control reg WR 
.equ en0_counter0 = 0x00d ;  	 Rcv alignment error counter RD 
.equ en0_dcfg = 0x00e ;  	 Data configuration reg WR 
.equ en0_counter1 = 0x00e ;  	 Rcv CRC error counter RD 
.equ en0_imr = 0x00f ;  	 Interrupt mask reg WR 
.equ en0_counter2 = 0x00f ;  	 Rcv missed frame error counter RD 
;
; Page 1 
;
.equ en1_phys = 0x001 ;  	 This board's physical enet addr RD WR 
.equ en1_curpag = 0x007 ;  	 Current memory page RD WR 
.equ en1_mult = 0x008 ;  	 Multicast filter mask array (8 bytes) RD WR 
;
; Chip commands in EN_CCMD 
.equ enc_stop = 0x001 ;  	 Stop the chip 
.equ enc_start = 0x002 ;  	 Start the chip 
.equ enc_trans = 0x004 ;  	 Transmit a frame 
.equ enc_rread = 0x008 ;  	 remote read 
.equ enc_rwrite = 0x010 ;  	 remote write 
.equ enc_nodma = 0x020 ;  	 No remote DMA used on this card 
.equ enc_page0 = 0x000 ;  	 Select page 0 of chip registers 
.equ enc_page1 = 0x040 ;  	 Select page 1 of chip registers 
.equ enc_page2 = 0x080 ;         page 2
.equ enc_page3 = 0x0c0 ;         page 3 (Realtek RTL8019AS chip)
;
; Commands for EN0_RXCR - RX control reg 
.equ enrxcr_crc = 0x001 ;  	 Save error pkts 
.equ enrxcr_runt = 0x002 ;  	 Accept runt pkt 
.equ enrxcr_bcst = 0x004 ;  	 Accept broadcasts 
.equ enrxcr_multi = 0x008 ;  	 Multicast (if pass filter) 
.equ enrxcr_promp = 0x010 ;  	 Promiscuous physical addresses 
.equ enrxcr_mon = 0x020 ;  	 Monitor mode (no packets rcvd) 
;
; Bits in EN0_TXCR - transmit control reg 
.equ entxcr_crc = 0x001 ;  		 inhibit CRC, do not append crc 
.equ entxcr_loop = 0x002 ;  		 Set loopback mode 
.equ entxcr_lb01 = 0x006 ;  		 encoded loopback control 
.equ entxcr_atd = 0x008 ;  		 auto tx disable 
.equ entxcr_ofst = 0x010 ;  		 collision offset enable 
;
; Bits in EN0_DCFG - Data config register 



.equ endcfg_wts = 0x001 ;  	 word transfer mode selection 

.equ endcfg_bos = 0x002 ;  	 byte order selection 
.equ endcfg_las = 0x004 ;  	 long addr selection 
.equ endcfg_bms = 0x008 ;  	 burst mode selection 
.equ endcfg_arm = 0x010 ;  	 autoinitialize remote 
.equ endcfg_ft00 = 0x000 ;  	 burst length selection 
.equ endcfg_ft01 = 0x020 ;  	 burst length selection 
.equ endcfg_ft10 = 0x040 ;  	 burst length selection 
.equ endcfg_ft11 = 0x060 ;  	 burst length selection 
;
; Bits in EN0_ISR - Interrupt status register 
.equ enisr_rx = 0x001 ;  	 Receiver, no error 
.equ enisr_tx = 0x002 ;  	 Transmitter, no error 
.equ enisr_rx_err = 0x004 ;  	 Receiver, with error 
.equ enisr_tx_err = 0x008 ;  	 Transmitter, with error 
.equ enisr_over = 0x010 ;  	 Receiver overwrote the ring 
.equ enisr_counters = 0x020 ;  	 Counters need emptying 
.equ enisr_rdc = 0x040 ;  	 remote dma complete 
.equ enisr_reset = 0x080 ;  	 Reset completed 
;
.equ enisr_all = 0x03f ;  	 Interrupts we will enable 
;
; Bits in received packet status byte and EN0_RSR 
.equ enrsr_rxok = 0x001 ;  	 Received a good packet 
.equ enrsr_crc = 0x002 ;  	 CRC error 
.equ enrsr_fae = 0x004 ;  	 frame alignment error 
.equ enrsr_fo = 0x008 ;  	 FIFO overrun 
.equ enrsr_mpa = 0x010 ;  	 missed pkt 
.equ enrsr_phy = 0x020 ;  	 physical/multicase address 
.equ enrsr_dis = 0x040 ;  	 receiver disable. set in monitor mode 
.equ enrsr_def = 0x080 ;  	 deferring 
;
; Bits in EN0_TSR -  TX status reg 
;
.equ entsr_ptx = 0x001 ;  	 Packet transmitted without error 
.equ entsr_dfr = 0x002 ;  	 non deferred tx 
.equ entsr_coll = 0x004 ;  	 Collided at least once 
.equ entsr_coll16 = 0x008 ;  	 Collided 16 times and was dropped 
.equ entsr_crs = 0x010 ;  	 carrier sense lost 
.equ entsr_fu = 0x020 ;  	 TX FIFO Underrun 
.equ entsr_cd = 0x040 ;  	 collision detect heartbeat 
.equ entsr_owc = 0x080 ;  	 out of window collision 
;
; Description of header of each packet in receive area of memory 
;
.equ en_rbuf_stat = 0 ;  	 Received frame status 
.equ en_rbuf_nxt_pg = 1 ;  	 Page after this frame 
.equ en_rbuf_size_lo = 2 ;  	 Length of this frame 
.equ en_rbuf_size_hi = 3 ;  	 Length of this frame 
.equ en_rbuf_nhdr = 4 ;  	 Length of above header area 
;
#line 9 "picweb.asm" 2

#line 1 "sdfmac.inc" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

.macro stxi
    ldi w,@0
    st x+,w
.endmacro

.equ pcode_signature = 0x95a8
.equ pcode_arg_mask = 3

.macro andwi
    andi @0l,low(@1)
    andi @0h,high(@1)
.endmacro

.macro pcode_routine
    .dw @0|pcode_signature
.endmacro

.macro label
.set @0 = pc
.endmacro

.macro coroutine
    pop zh
    pop zl
.endm

.macro ldsw
    lds @0l,@1
    lds @0h,@1+1
.endmacro

.macro stsw
    sts @0,@1l
    sts @0+1,@1h
.endmacro

.macro pushw
    push @0h
    push @0l
.endmacro

.macro popw
    pop @0l
    pop @0h
.endmacro

.macro shrw
    lsr @0h
    ror @0l
.endmacro

.macro shlw
    lsl @0l
    rol @0h
.endmacro

.macro tstb
    mov w,@1
    and w,@0
.endmacro

.macro tstbi
    ldi w,@1
    and w,@0
.endmacro

.macro cmpw
    cp @0l,@1l
    cpc @0h,@1h
.endmacro

.macro cmpwi
    cpi @0l,low(@1)
    ldi w,high(@1)
    cpc @0h,w
.endmacro

.macro  coroutine_call
    pop zh
    pop zl
    icall
.endmacro

.macro coroutine_done
    pop zh
    pop zl
.endmacro

.macro coroutine_return
    push    zl
    push zh
    ret
.endmacro

.macro coroutine_setup
    push    zl
    push    zh
.endmacro

.macro putchar
	ldi	ch,@0
	rcall import_do_putchar
.endmacro

.macro hexb
    rcall do_hexb
.endmacro

.macro space
    rcall do_space
.endmacro

.macro crlf
    rcall do_crlf
.endmacro

.macro addwi
    ldi w,low(@1)
    add @0l,w
    ldi w,high(@1)
    adc @0h,w
.endmacro

.macro addw
    add @0l,@1l
    adc @0h,@1h
.endmacro

.macro subwi
    ldi w,low(@1)
    sub @0l,w
    ldi w,high(@1)
    sbc @0h,w
.endmacro

.macro subw
    sub @0l,@1l
    sbc @0h,@1h
.endmacro

.macro movwi
	ldi	@0l,low(@1)
	ldi	@0h,high(@1)
.endmacro

.macro clrw
    clr @0l
    clr @0h
.endmacro

.macro decw
    subi @0l,1
    sbci @0h,0
.endmacro

.macro incw
    subi @0l,-1
    sbci @0h,-1
.endmacro

.macro ldsbw
	lds	@0l,@1
    clr @0h
.endmacro

.macro movw
    mov @0l,@1l
    mov @0h,@1h
.endmacro

.macro outstr
    rcall import_do_outstr
	.dw	(@0*2)
.endmacro

.macro hexy
    rcall hexy
.endmacro

.macro outstrs
	ldi	yl,low(@0)
	ldi	yh,high(@0)
    rcall do_outstrs
.endmacro

.macro setport
    ldi r16,@1
    mov i0,r16
    ldi r16,@0
    rcall isa_out
.endmacro

.macro isa_out
    rcall   isa_out
.endmacro

.def r0l =r0
.def r0h =r1
.def r1l =r1
.def i0 =r2
.def r1h =r2
.def r2l =r2
.def i1 =r3
.def r2h =r3
.def r3l =r3
;.def i2 =r4
;.def r3h =r4
;.def r4l =r4
;.def r4h =r5
;.def r5l =r5
.def pl=r4
.def ph=r5  ; pcode PC low, high
;.def r5h =r6
.def r6l =r6
.def r6h =r7
.def r7l =r7
.def r7h =r8
.def r8l =r8
.def r8h =r9
.def r9l =r9
.def r9h =r10
.def r10l =r10
.def r10h =r11
.def r11l =r11
.def r11h =r12
.def r12l =r12
.def r12h =r13
.def r13l =r13
.def r13h =r14
.def r14l =r14
.def r14h =r15
.def r15l =r15
.def r15h =r16
.def r16l =r16
.def r16h =r17
.def r17l =r17
.def r17h =r18
.def r18l =r18
.def r18h =r19
.def r19l =r19
.def r19h =r20
.def r20l =r20
.def r20h =r21
.def r21l =r21
.def r21h =r22
.def r22l =r22
.def r22h =r23
.def r23l =r23
.def r23h =r24
;; reserved for macros.
.def r24l = r24
.def r24h = r25

;.def wl   =r24
.def w    =r25
;.def wh   =r25
;.def w1   =r25

.def r25h =r26
.def r26l =r26
.def xl  =r26
.def r26h =r27
.def r27l =r27
.def xh  =r27

.def r27h =r28
.def r28l =r28
.def yll  =r28
.def r28h =r29
.def r29l =r29
.def ylh  =r29

.def r29h =r30
.def r30l =r30
.def zl  =r30
.def r30h =r31
.def r31l =r31
.def zh  =r31
#line 10 "picweb.asm" 2

#line 1 "isa.inc" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

#line 16 "isa.inc"

.macro isa_delay
	nop		; 1 clock  (125 ns / clock @ 8 MHz)
	nop		; 1 clock
	nop		; 1 clock
	nop		; 1 clock
.endmacro


#line 11 "picweb.asm" 2

#line 1 "timing.inc" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------



.macro zero_timer
.endmacro
.macro show_timer
.endmacro
.macro zero_timer_inline
.endmacro
.macro show_timer_inline
.endmacro

#line 52 "timing.inc"

#line 12 "picweb.asm" 2

#line 1 "tcpip.inc" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------








;    unsigned        hdrlen  : 4;
;    unsigned        ver     : 4;
;    byte            tos;
;    word            length;
;    word            identification;
;    unsigned        frags : 3;
;    unsigned        fo    : 13;
;    byte            ttl;
;    byte            proto;
;    word            checksum;
;    longword        source;
;    longword        destination;
.equ IPH = (6+6+2)			    ; offset from start of frame to start of ip hdr
.equ IPD = IPH+20               ; offset to start of IP data
.equ IP_HVTOS   = IPH+0
.equ IP_LEN     = IPH+2
.equ IP_ID      = IPH+4
.equ IP_FFO     = IPH+6
.equ IP_TTLP    = IPH+8
.equ IP_CHKSUM  = IPH+10
.equ IP_SRCADDR = IPH+12
.equ IP_DSTADDR = IPH+16


;;; start of TCP header.
;    word            srcPort;
;    word            dstPort;
;    longword        seqnum;
;    longword        acknum;
;    word            flags;
;    word            window;
;    word            checksum;
;    word            urgentPointer;
.equ TCP_HEADER = IPD+0
.equ TCP_SP     = IPD+0
.equ TCP_DP     = IPD+2
.equ TCP_SEQ    = IPD+4
.equ TCP_ACK    = IPD+8
.equ TCP_FLAGS  = IPD+12
.equ TCP_WIN    = IPD+14
.equ TCP_CHKSUM = IPD+16
.equ TCP_URG    = IPD+18
.equ TCP_DATA   = IPD+20
.equ TCP_HEADER_LEN = 20
.equ UDP_HEADER = IPD+0
.equ UDP_SP         = UDP_HEADER+0
.equ UDP_DP         = UDP_HEADER+2
.equ UDP_LEN        = UDP_HEADER+4
.equ UDP_CHKSUM     = UDP_HEADER+6
.equ UDP_DATA       = UDP_HEADER+8












#line 13 "picweb.asm" 2


.macro export
.endmacro

.device	AT90S8515	;Prohibits use of non-implemented instructions
.def	ch	    = r25           ; character for putchar - also a temp (w1)

.equ	stackend = ramend



; interrupt vectors.

	rjmp	RESET		;Reset Handle
	rjmp	int0_isr
	rjmp	int1_isr
	rjmp	timer1cap_isr
	rjmp	timer1compa_isr
	rjmp	timer1compb_isr
	rjmp	timer1ovf_isr
	rjmp	timer0ovf_isr
	rjmp	spistc_isr
	rjmp	rx_isr
	rjmp	udre_isr
	rjmp	tx_isr
	rjmp	ana_comp_isr

.include "picbin.inc"


int0_isr:
int1_isr:
timer1cap_isr:
timer1compa_isr:
timer1compb_isr:
timer1ovf_isr:
timer0ovf_isr:
spistc_isr:
udre_isr:
tx_isr:
ana_comp_isr:
	putchar	'?'
	putchar	'?'
	rjmp	reset
#line 123 "picweb.asm"


;***** Code

RESET:
	clr r17
	out	sreg,r17
	out gimsk,r17		; disable INT0/INT1
	out mcucr,r17
    sts serial_mode,r17
	sts ccaddr,r17
	sts ccaddr+1,r17
    sts pcode_debug_flag,r17







	ser r17
;    	sts pcode_debug_flag,r17	;; !!!! force pcode debug !!!!

	sts neon,r17                ; turn on ne2000 driver

	sts nelog,r17

;;;;;;;;;;;;;;;;;  control-C comes here...
reset1:

	ldi r16,0x0F	; enable watchdog timer (~2 sec.)
	out wdtcr,r16
	wdr		; reset watchdog timer

	clr r17
	sts xoff,r17				; not xoffed
	sts putc_b,r17              ; putchar is "normal"

	sts pkt_wdog_cnt,r17	; zero packet watchdog counter


; initialize SP to top of SRAM.

	ldi	w,low(stackend)
	out	spl,w
	ldi	w,high(stackend)
	out	sph,w
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;; DO NOT DO ANY [R]CALL instructions before this point! ;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	rcall   i2c_init
	sbi     ddrd,0








; set serial port baud rate.

	ldi	r17,25              	; 9600 Baud with a 4Mhz clock
	out	UBRR,r17

; enable transmitter and receiver, and enable receiver interrupts.

 	ldi	r17,(1<<rxcie)|(1<<rxen)|(1<<txen)
	out	UCR,r17

; enable global interrupts.

	ldi	r17,0x80
	out	sreg,r17
    sei


; start temperature conversion
	ldi	yl,0xEE
	rcall	ds1621_write


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




	ser r17

	sts putcok,r17                  ; turn on putchar
	ldi r18l,4                      ; 4 bytes

#line 229 "picweb.asm"


;
; get ip address from eeprom/seeprom.
;
	movwi x,my_ip

	movwi y,eeprom_ip_addr
	rcall eeprom_read_bytes





#line 251 "picweb.asm"



	outstr hello ;;string hello "\r\nFrey'nHell-Light PicoWeb v$$VERSION$$"


	rcall pcode_init                ; initialize pcode engine
	rcall network_init




	crlf
	ldi r17,6
	putchar 'e'
	putchar 'a'
	putchar '='
	movwi x,my_ether
show_ether1:
	ld i0,x+
	hexb
	dec r17
	brne show_ether1







#line 289 "picweb.asm"


	ldsw yl,ccaddr			        ; show PC (from ^C interrupt)
	mov r0,yl
	or r0,yh
	breq doprompt
	crlf
	putchar '@'
	rcall hexy

doprompt:


	outstr prompt                   ;;string prompt "\r\n# "

	clr r17
	sts	nch,r17
	sts	ready,r17
;
; command loop - wait for CR, call ne2000 handler.
;
loop:
;
; this counter wraps about every 1.5 seconds on an 8515/4 with the current
; processing load.  SDF 1998/11/15.
;

	wdr		; reset watchdog timer

	clr r0
	ldi r17,1
	lds r16,timer
	add r16,r17
	sts timer,r16
	lds r16,timer+1
	adc r16,r0
	sts timer+1,r16
	brcc loop1
	; the timer has counted down.







	lds r17,neon
	or r17,r17
	breq no_pkt_wdog

	lds r17,pkt_wdog_cnt	; bump/check net watchdog
	inc r17
	sts pkt_wdog_cnt,r17
	cpi r17,250
	brne no_pkt_wdog






	rcall network_init	; reset network chip

	clr r17
	sts pkt_wdog_cnt,r17    ; zero packet watchdog counter
no_pkt_wdog:


loop1:
;
; check if NE2000 code is enabled, if so, set logging flag based on nelog, and
; call NE2000 logic, then enable logging.
;
	lds r17,neon
	or r17,r17
	breq ne_off

	lds r17,nelog
	sts putcok,r17          ; enable/disable output based on nelog flag

	rcall network

	ser r17
	sts putcok,r17          ; turn output back on

ne_off:
;
; if no command, keep looping.
;
	lds	w,ready
	tst	w
	breq	loop            ; if CR not yet pressed...
;;
;; there is a command in the input buffer, nul-terminate it.
;;
	ldsbw z,nch
	addwi z,inbuf
	ldi	r17,0
	st	z,r17               ; nul-terminate
;;
;; process command.
;;
	crlf
	rcall cli_exec
	rjmp doprompt
;+
; **-udp_recv-udp receive handler.
;-

import_udp:
    ret

;+
; **-pwdr-pcode watchdog reset.
;
; inputs:
;	none
;-

pwdr:	pcode_routine	0

	wdr		; reset watchdog timer

	ret

.eseg
.org 1




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;; any/all user EEPROM data MUST follow ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


eeprom_ip_addr:
#line 1 "ip.inc" 1
	.db	0xc0	; IP 192.245.227.127
	.db	0xf5
	.db	0xe3
	.db	0x7f
#line 426 "picweb.asm" 2



eeprom_setpt:	.db 70          ; default temperature setpoint
.cseg

#line 441 "picweb.asm"


import_unknown_ipaddr:

    ret

#line 1 "serial.asm" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------



com_circular:
    lds r17,com_in      ; get IN index
    lds r18,com_out     ;  and OUT index
    inc r17
    andi r17,(max_nch-1)   ; wrap it
    cp r17,r18          ; check it
    breq count_lost     ; sorry - we lost a char

    pushw z
    clr zh
    lds zl,com_in
    addwi z,inbuf
    in r18,udr
    st z,r18
    popw z

    sts com_in,r17      ; advance IN index
    rjmp com_bail       ; bail out
count_lost:
    in r18,udr          ; dump the byte to clear interrupt
    lds r17,com_lost
    inc r17
    sts com_lost,r17
    rjmp com_bail

rx_isr:
    push w
	push	r17
	push    r18
	in	r18,sreg
	push r18
    lds r18,serial_mode
    tst r18
    brne com_circular
	in	r17,udr
	cpi	r17,3	    ; Control-C does a reset
	breq	gores
	push	yl
	push	yh
	cpi r17,0x13    ; control-S - set xof flag
	breq go_xoff
	cpi r17,0x11    ; control-Q - clear xof flag
	breq go_xoff
	lds	r18,ready
	tst	r18
	brne	rxignore
	cpi	r17,0x0d
	brne	nocr
is_cr:
	sts	ready,r17
	rjmp	rxignore
go_xoff:
	andi    r17,2       ; isolate on/off bit
	sts xoff,r17
	rjmp rxignore
nocr:
    cpi r17,0x0a        ; also allow LF
    breq is_cr
	lds	yl,nch
	ldi yh,0
	cpi	yl,max_nch
	brlt	rxok
	ldi	r17,'!'
	rjmp	rxecho
rxok:
	mov	r18,yl
	addwi y,inbuf
	st	y,r17
	inc	r18
	sts	nch,r18
rxecho:
	out	udr,r17
rxignore:
	pop	yh
	pop	yl
com_bail:
	pop	r18
	out	sreg,r18
	pop	r18
	pop	r17
    pop w
	reti
gores:
    pop r17
    pop r17
    pop r17
    pop r17

; stack is in same state as on initial entry to interrupt.

    pop yh
    pop yl
    stsw ccaddr,y
    rjmp reset1
import_do_putchar:
do_putchar:
	push    r17
	lds r17,putc_b          ; check if going to board
	tst r17
    brne putc_to_board
	lds r17,putcok
	tst r17
	breq putc_off
wait_xon:
	lds r17,xoff            ; check xof flag
	or r17,r17
	brne wait_xon
do_put1:
	in	r17,usr
	bst	r17,udre	; check if data register empty
	brtc	do_put1
	out	udr,ch		; start transmission
putc_off:
	pop r17
	ret
putc_to_board:
	rcall do_bputc
	rjmp putc_off
;+
; **-pser_mode-pcode set mode on serial port.
;
; inputs:
;   r10l = mode as: 0-normal, non-zero-enable pass-all (binary) mode.
;
; outputs:
;   buffer flushed and characters being stored appropriately.
;-

pser_mode:  pcode_routine   1
    clr r10h
 	ldi	r17,(1<<rxen)|(1<<txen)     ; disable receive interrupts
	out	UCR,r17
    tst r10l
    breq psb_normal
    ;
    ; entering binary mode - reset buffer pointers if not already in
    ; binary mode.
    ;
    lds r17,serial_mode
    cp r17,r10l
    breq pserial_noreset
    sts com_in,r10h
    sts com_out,r10h
pserial_noreset:
    inc r10h
pserial_done:
 	ldi	r17,(1<<rxcie)|(1<<rxen)|(1<<txen)     ; enable receive interrupts
	out	UCR,r17
    sts serial_mode,r10h
    ret
psb_normal:
    sts nch,r10h
    rjmp pserial_done
;+
; **-pser_putc-pcode serial port putchar.
;
; inputs:
;   r10 = character to transmit
;
; outputs:
;   transmission to serial port initiated.
;
; notes:
;   waits for a "transmit done" indication on the serial port
;   before transmitting this character.
;-

pser_putc:  pcode_routine 1
    push r17
    mov ch,r10l
    rjmp do_put1
;+
; **-pser_getc-pcode serial port getchar.
;
; outputs:
;   r10 -> resulting byte
;   condition codes set so that a jumpeq will take if buffer empty.
;-

pser_getc:  pcode_routine   1
    lds r17,com_in
    lds r18,com_out
    cp r17,r18
    brne pser_getc_got_byte
    rjmp set_pcode_flags
pser_getc_got_byte:
    movw x,r10              ; where to store it
    mov zl,r18              ; get OUT index low 1/2
    clr zh                  ; clear top 1/2
    addwi z,inbuf           ; bias for buffer
    ld r12l,z               ; get the byte
    st x,r12l               ; store it
    inc r18
    andi r18,(max_nch-1)       ; wrap it
    sts com_out,r18         ; store it back
    clz
    rjmp set_pcode_flags    ; jumpne will take now
#line 447 "picweb.asm" 2






#line 1 "cmd.asm" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

import_cli_exec:
cli_exec:       export

	clr r20			; default to bad command
	sts cmd_ok,r20

	rcall pcode
#line 1 "cmd.inc" 1
;;;;;;;;;;;;;;;;;;;;;; DO NOT EDIT THIS FILE!!! ;;;;;;;;;;;;;;;;;;;;;
;
;   AUTOMATICALLY GENERATED from: cmd2asm.pl cmd.txt
;
;;;;;;;;;;;;;;;;;;;;;; DO NOT EDIT THIS FILE!!! ;;;;;;;;;;;;;;;;;;;;;




























;
; command dispatch table
;
	.dw pchk_cmd,0x7377,seeprom_write        ; ws
	.dw pchk_cmd,0x6d77,sram_write           ; wm
	.dw pchk_cmd,0x6577,eeprom_write         ; we
	.dw pchk_cmd,0x6470,pcode_debug_toggle   ; pd
	.dw pchk_cmd,0x526e,board_dump           ; nR
	.dw pchk_cmd,0x006c,log_toggle           ; l
	.dw pchk_cmd,0x7364,dump_seeprom         ; ds
	.dw pchk_cmd,0x6d64,dump_sram            ; dm
	.dw pchk_cmd,0x6564,dump_eeprom          ; de
	.dw pchk_cmd,0x005a,zap_sram             ; Z
	.dw pchk_cmd,0x4350,do_pcode_call        ; PC
	.dw pchk_cmd,0x0049,iosweep              ; I

#line 14 "cmd.asm" 2

	.dw 0

	lds r20,cmd_ok		; command OK?
	cpi r20,0
	brne cli_exec_ok
	putchar '?'

cli_exec_ok:
	ret

import_do_outstr:
do_outstr:      export
	pop	zh		; z = (sp)+
	pop	zl
	lsl	zl
	rol	zh		; convert return address to data pointer
	lpm
	ori zl,1
	mov	r1,r0
	lpm			; [r0:r1] = pointer to string (already *2)
	adiw	zl,1
	shrw z
	push	zl
	push	zh		; put incremented return addr back on stack
	mov	zl,r1
	mov	zh,r0
nextchar:
	lpm
	adiw	zl,1		; advance pointer to next byte
	tst	r0
	breq	outstrdone
	mov	ch,r0
	rcall	do_putchar	; slam it out
	rjmp	nextchar
outstrdone:
	ret

do_outstrs:
nextchars:
	ld	i0,y+
	tst	i0
	breq	outstrdones
	mov	ch,i0
	rcall	do_putchar	; slam it out
	rjmp	nextchars
outstrdones:
	ret
;+
; **-dumpsram-dump sram in hex.
;-

dump_sram:
	movwi z,readb_y
dumpx:








#line 87 "cmd.asm"

	ldsw	y,cmdop1
	ldsw	r21,cmdop2
	cpi	r22,0		; no more than 128!
	brne	dumpsr0		; branch if MSB non-zero
	sbrs	r21,7		; skip if bit 7 of LSB set
	rjmp	dumpsr3
dumpsr0:
	;;;;;;;clr	r22		; limit count
	;;;;;;ldi	r21,0x80
	movwi	r21,512
dumpsr3:
	addw	r21,y
dumpsr1:

	mov	ch,yl
	andi	ch,0x0f
	brne	dumpsr2
	crlf
	rcall	hexy
dumpsr2:
	space
	pushw z
	icall
	popw z
	hexb
	cp	yl,r21
	brne	dumpsr1
	cpc	yh,r22
	brlt	dumpsr1
	crlf








	ret

readb_y:
	ld i0,y+
	ret
pcode_debug_toggle: lds yl,cmdop1
    sts pcode_debug_flag,yl
    ret
;+
; **-dump_eeprom-dump eeprom.
;-

dump_eeprom:
	movwi z,eeprom_read
	rjmp dumpx
;+
; **-dump_seeprom-dump seeprom.
;-

dump_seeprom:
	movwi z,seeprom_read
	rjmp dumpx
;+
; **-do_pcode_call-do a pcode call (pcall)
;
; inputs:
;   cmdop1  = word containing address to call (no checking!!!)
;
; outputs:
;   who knows!!
;-

do_pcode_call:
    pushw p
    rcall pcode
    .dw pcall|XX,(XX|XW|(cmdop1))
    .dw 0






    popw p
    ret
;+
; **-hexcvtb-hex convert byte.
;
; inputs:
;       x -> buffer
;
; outputs:
;       i0  = byte value
;       x   = x + 2
;-

hexcvtb:            export
	push r16
	push i1

	clr i0			; default to zero
	ld r16,x+               ; get next byte
	rcall h2nib		; convert it
	ld r16,x+               ; get next byte
	rcall h2nib

	pop i1
	pop r16
	ret


;+
; **-hexcvtw-hex convert word.
;
; inputs:
;       x -> buffer
;
; outputs:
;       i0,i1  = word value
;       x      = point to next character < '0'
;-

hexcvtw:
	push r16

	clr i0			; default to zero
	clr i1
h2w0:
	ld r16,x		; get next nibble

	cpi r16,'0'
	brlt h2wx       	; <'0'...time to exit
	incw x			; bump x
	rcall h2nib		; convert nibble in r16
	rjmp h2w0
h2wx:
	pop r16
	ret

h2nib:
	cpi r16,('9'+1)
	brge h2w1               ; not a number - must be a-f or a-f

	subi r16,'0'
	rjmp h2w2
h2w1:
	andi r16,7              ; a-f/A-F becomes 1-6 (a=61, A=41)
	subi r16,-9             ; x--9 == x+9, 1 becomes 0x0a
h2w2:
	lsl r16			; shift to upper nibble
	lsl r16
	lsl r16
	lsl r16

	push r17
	ldi r17,4
h2w3:
	rol r16
	rol i0
	rol i1
	dec r17
	brne h2w3
	pop r17
	ret

;+
; **-hexmem_x-hex dump of memory.
;
; inputs:
;       x   = starting address
;       r16 = byte count
;
; outputs:
;       x   = advanced beyond bytes printed
;       r16 = 0
;-

hexmem_x:
	space
	ld i0,x+
	hexb
	dec r16
	brne hexmem_x
	ret
;+
; **-pspace-pcode output a space.
;
; outputs:
;   outputs a single space (0x20) via equivalent of pputc.
;-

pspace: pcode_routine 0
do_space:
	push ch
	putchar ' '
	pop ch
	ret
;+
; **-pputcb-pcode putchar byte.
;
;   r10 -> byte to output
;-

pputcb:  pcode_routine 1
	movw x,r10
	ld ch,x+
	rjmp do_putchar
;+
; **-pputc-pcode putchar equivalent.
;
; inputs:
;   r10l    = character to output
;   putc_b  = control flag 0=output to serial port, else -> transmit stream.
;
; outputs:
;   byte written to serial port, or to transmit stream, or stored in
;   holding buffer pending flush of transmit buffer.
;-

pputc:  pcode_routine 1
	mov ch,r10
	rjmp do_putchar
#line 316 "cmd.asm"


#line 332 "cmd.asm"












sram_write:
	st y,r20
	ret


neon_toggle:
	lds r17,neon
	com r17
	sts neon,r17
	rjmp showtoggle

log_toggle:
	lds r17,nelog
	com r17
	sts nelog,r17
showtoggle:
	mov i0,r17
	hexb
	ret

#line 372 "cmd.asm"


#line 388 "cmd.asm"



board_dump:
	movwi r20,0x4600        ; start at first receive buffer
	movwi r18,(SM_RSTOP_PG<<8)-(SM_RSTART_PG<<8)
	movwi z,bdd1
	rcall ne_rstart         ; start transfer
	ret


bdd1:

	wdr             ; reset watchdog timer

	tstbi r18l,0x1f         ; check if time for new line
	brne bdd2
	crlf
	movw y,r20
	rcall hexy
	space
bdd2:
	hexb
	mov i0,i1
	hexb             ; byte mode
	addwi r20,1
	ldi w,0x1f
	and w,r20l
	cpi w,0x10
	brne bdd3
	space
bdd3:
	ret


;;
;; ethernet register disgnostic
;;
ea_reg_diag:
	clr r17
	sts	nch,r17
	sts	ready,r17
	setport en_ccmd,enc_nodma+enc_page1

ea_reg_diag_1:

	ldi r17,6
	ldi r16,1		; starting at port 1
next_ea_1:
	mov i0,r17
	rcall    isa_out
	inc r16
	dec r17
	brne next_ea_1

	ldi r17,6
	ldi r16,1		; starting at port 1
next_ea_2:
	rcall    isa_in
	space
	hexb
	inc r16
	dec r17
	brne next_ea_2
	crlf

	lds	w,ready
	tst	w
	breq	ea_reg_diag_1            ; if CR not yet pressed...

	rcall iosweep

	setport en_ccmd,enc_nodma+enc_page0
	ret


import_iosweep:
iosweep:
	setport en_ccmd,enc_nodma+enc_page0
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page1
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page2
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page3
	rcall iosweep1
	setport en_ccmd,enc_nodma+enc_page0
	ret
iosweep1:
;;
;; sweep the possible I/O space - see what's out there!
;;
	ldi r17,16              ; was 32 - but don't do it now for NE2000
	                        ; because upper ports if read without conditioning for
	                        ; transfer cause problems on REAL ISA bus - why???
	clr r16                 ; starting at port 0
nextboard:
	rcall    isa_in
	space
	hexb
	inc r16
	dec r17
	brne nextboard
	crlf
	ret
;
;   p-code command checker
;
;   r10 = 1- or 2-byte command code
;   r12 = routine to call if command codes match
;
pchk_cmd:  pcode_routine 2
	movw r18,r10		; move target command bytes to r18
	movwi x,inbuf		; move input buffer pointer to x
	ld r16,x+		; get first character of input command buffer
	cp r16,r18		; match with command?
	brne chk_cmd_exit	; no...exit
	cpi r19,0		; yes...more command bytes?
	breq chk_cmd_1		; no...execute command
	ld r16,x+		; get second character of input command buffer
	cp r16,r19		; match with command?
	brne chk_cmd_exit	; no...exit
chk_cmd_1:
	sts cmd_ok,r18		; show good command
	incw x			; skip character
	rcall hexcvtw		; get next hex word from command buffer
	sts cmdop1,i0		; save as LSB of address
	sts cmdop1+1,i1		; save as MSB of address

	incw x			; skip character
	rcall hexcvtw		; get next hex word from command buffer
	mov r20,i0		; r20/21 = parameter #2
	mov r21,i1		;
	sts cmdop2,i0		; save as LSB of count/word
	sts cmdop2+1,i1		; save as MSB of count/word

	ldsw y,cmdop1		; y = parameter #1
	movw z,r12		; call routine
	icall






chk_cmd_exit:
	ret


zap_sram:		; y has first parameter
	movwi x,0x60	; base of SRAM
	movwi r18,512	; size
	mov r20,yl	; we'll write this value everywhere
zap_sram1:
	st x+,r20
	decw r18
	brne zap_sram1
	rjmp RESET	; reset processor



show_ether:                     ; display ethernet address
    putchar 'e'
    putchar 'a'
    putchar ' '
    putchar '='
    movwi   x,my_ether
    ldi r16,6
    rjmp hexmem_x
#line 453 "picweb.asm" 2

#line 1 "cgipcode.asm" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

.eseg
.org 0x8000+0x3800

;
; top two bits set in length indicate CGI.  actually the length is not
; really used except for the flags.  up to the CGI code to return on its
; own!
;-
















cgi_table:
    .dw (cgi_table_end-cgi_table)/4
     .dw cgi00,(cgi00_end- cgi00)|(0x8000+0x4000)    ; flags as CGI				; iu00
     .dw cgi01,(cgi01_end- cgi01)|(0x8000+0x4000)    ; flags as CGI				; iu01
     .dw sertest,(sertest_end- sertest)|(0x8000+0x4000)    ; flags as CGI			; iu02
     .dw time_from_server,(time_from_server_end- time_from_server)|(0x8000+0x4000)    ; flags as CGI	; iu03






     .dw cginull,(cginull_end- cginull)|(0x8000+0x4000)    ; flags as CGI	    ; iu04

     .dw temp_top,(temp_top_end- temp_top)|(0x8000+0x4000)    ; flags as CGI           ; iu05
     .dw temp_bottom,(temp_bottom_end- temp_bottom)|(0x8000+0x4000)    ; flags as CGI        ; iu06
     .dw set_point,(set_point_end- set_point)|(0x8000+0x4000)    ; flags as CGI          ; iu07
     .dw setpoint_finger,(setpoint_finger_end- setpoint_finger)|(0x8000+0x4000)    ; flags as CGI    ; iu08






     .dw cginull,(cginull_end- cginull)|(0x8000+0x4000)    ; flags as CGI	    ; iu09






#line 73 "cgipcode.asm"

     .dw cginull,(cginull_end- cginull)|(0x8000+0x4000)    ; flags as CGI	    ; iu0a


cgi_table_end:

;+
; **-cginull-dummy.
;-

 
    cginull:
#line 86 "cgipcode.asm"
    .dw pret
cginull_end:

;+
; **-cgi00-testor.
;-

 
    cgi00:
#line 96 "cgipcode.asm"
    .dw pmovbi,(UBRR+0x20),25              ; 19.2KB
     .dw pser_mode,0                       ; temporary kludge
    .dw pprint,ehtml_header
    .dw pprint,ereset_msg   ;;eestring ereset_msg "Serial reset.\n"
    .dw pret
cgi00_end:

;+
; **-temperature-show the temperature in decimal.
;-
 
    cgi01:
#line 109 "cgipcode.asm"
    .dw pcall,tempf_buf
    .dw pcall,update_heater
    .dw pjump,decconv                   ; convert to decimal ascii
cgi01_end:
;+
; **-sertest-serial I/O testor.
;-

 
    sertest:
#line 120 "cgipcode.asm"
    .dw pmovbi,(UBRR+0x20),51
    .dw pprint,ehtml_header
;;eestring ehtml_header "HTTP/1.0 200\nContent-type: text/html\n\n"
     .dw pmovbi,putc_b,0                      ; switch putchar to serial port
    .dw pmovwi|XX,buf,(XX|XW|(data_addr))   ; get data address
    .dw paddwi,buf,10                   ; GET /iu02?X
    .dw pmovwi|XX,buf+2,(XX|XW|(data_len))
sertest_next:
    .dw pr2s|XX,buf+4,(XX|XW|(buf)),1       ; get next byte
    .dw pandwi,buf+4,0xff
    .dw pcmpwi,buf+4,'.'
    .dw pjumpeq,serial_done
    .dw pputcb,buf+4
    .dw paddwi,buf,1                    ; bump data address
    .dw psubwi,buf+2,1
    .dw pjumplo,serial_done
    .dw pjumpne,sertest_next
serial_done:
    .dw pmovbi,buf,0x0d
    ;
    ; come here with request char in buf.
    ;
serial_request:
    .dw pmovwi,buf+4,800            ; select the timeout period
    .dw pmovbi,com_lost,0               ; zero out lost char counter
     .dw pser_mode,0
     .dw pser_mode,1                       ; put serial port in binary mode
     .dw pmovbi,putc_b,0                      ; switch putchar to serial port
    .dw pputcb,buf                      ; output to serial port
     .dw pmovbi,putc_b,1                         ; switch putchar back to 'net
;
; loop reading chars from the serial buffer and writing to 'net until
; there are no more characters.
;
    .dw pmovwi|XX,buf+2,(XX|XW|(buf+4))     ; timeout
    .dw pcall,fsertest




    .dw pret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.cseg

fsertest:
;
; buf+4 (word) = timeout loop count, and buf+2 is already loaded with
; that timeout value.
;
sertest_nextchar:
    .dw pser_getc,buf                   ; get a char into buf
    .dw pjumpeq,sertest_empty           ; no more chars!
    .dw pputcb,buf                      ; put char to the net
    .dw pmovwi|XX,buf+2,(XX|XW|(buf+4))     ; timeout
    .dw pjump,sertest_nextchar          ; go get another one
sertest_empty:
    .dw psubwi,buf+2,1                  ; decrement timeout
    .dw pjumpne,sertest_nextchar        ; not yet timed out
    .dw pret

.eseg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sertest_end:

 
    time_from_server:
#line 190 "cgipcode.asm"
    .dw pmovbi,buf,'T'                  ; time request
    .dw pjump,serial_request            ; get time from server
time_from_server_end:

#line 462 "cgipcode.asm"


#line 636 "cgipcode.asm"


#line 718 "cgipcode.asm"


;+
; **-decconv-decimal converter.
;
; inputs:
;   buf = word to convert
;
; outputs:
;   result printed (with pputc)
;
; caveats:
;   MUST be called with pcall!!
;-





decconv:    .dw pmovwi,buf+4,buf+6         ; pcode_routine
    .dw pbitwi,buf,0x8000           ; check the sign
    .dw pjumpeq,decconv1                ; positive - start conversion
    .dw pnegw,buf                   ; negate it
    .dw pputc,'-'
decconv1:
    .dw pdiv|XX,buf,(XX|XW|(buf)),10    ; get next one
    .dw paddwi,buf+2,'0'              ; convert digit for display
    .dw pmovbi|XX,(XX|XW|(buf+4)),(XX|(buf+2))  ; save digit
    .dw paddwi,buf+4,1                ; bump past digit just stored
    .dw psubwi,buf,0                ; test remaining value
    .dw pjumpne,decconv1                 ; if more to convert
decconv2:
    .dw psubwi,buf+4,1                ; point to next one
    .dw pputcb|XX,(XX|(buf+4))         ; show it
    .dw pcmpwi,buf+4,buf+6          ; check if just did last one
    .dw pjumpne,decconv2                 ; nope - do next one
    .dw pret

 
    temp_top:
#line 759 "cgipcode.asm"
    .dw pcall,tempf_buf
    .dw pcall,compute_top
    .dw pjump,decconv
temp_top_end:
compute_top:
    .dw pmovwi,buf+2,130
    .dw psubwi|XX,buf+2,(XX|XW|(buf))
    .dw pshnw,buf+2,1
    .dw pmovwi|XX,buf,(XX|XW|(buf+2))
    .dw pret
 
    temp_bottom:
#line 772 "cgipcode.asm"
    .dw pcall,tempf_buf
    .dw pshnw,buf,1
    .dw pjump,decconv
temp_bottom_end:

 
    set_point:
#line 780 "cgipcode.asm"
    .dw pr2s|XX,buf,(XX|XW|(data_addr)),16
    .dw pcmpbi,buf+9,'?'            ; GET /iiNN?s=xx        ; we want xx
                                    ; 01234567890123
    .dw pjumpne,not_setting_setpoint
    .dw pclrw,buf
    .dw pclrw,buf+2
    .dw pmovbi|XX,buf,(XX|(buf+12))
    .dw psubwi,buf,'0'
    .dw pmul|XX,buf,(XX|XW|(buf)),10    ; do first digit
    .dw pmovbi|XX,buf+2,(XX|XW|(buf+13))
    .dw psubwi,buf+2,'0'
    .dw paddwi|XX,buf,(XX|XW|(buf+2))
    .dw peeprom_write|XX,eeprom_setpt,(XX|(buf))
not_setting_setpoint:
    .dw pcall,get_setpoint
    .dw pjump,decconv
set_point_end:
get_setpoint:
    .dw pcall,update_heater
    .dw pclrw,buf
    .dw ee2s,buf,1,1
    .dw pret


update_heater:








    .dw pret
heater_on:
    .dw pmovbi,PORTD+0x20,0
    .dw pret
tempf_buf:
    .dw pclrw,buf



    .dw pread_temp,buf                  ; get temp

    .dw pmovwi,buf+4,0x80              ; set up for sign test
    .dw pandwi|XX,buf+4,(XX|XW|(buf))       ; check the sign
    .dw pjumpeq,temp_positive            ; it is positive
    .dw pmovbi,buf+1,0xff              ; extend the sign
    .dw pnegw,buf                       ; negate
temp_positive:
    .dw pmul|XX,buf,(XX|XW|(buf)),9         ; C*9
    .dw pdiv|XX,buf,(XX|XW|(buf)),5         ; /5
    .dw pandwi,buf+4,0x80               ; test original sign
    .dw pjumpeq,temp_norenegate          ; positive
    .dw pnegw,buf
temp_norenegate:
    .dw paddwi,buf,32                   ; +32 - buf now has temp (F)
    .dw pret
 
    setpoint_finger:
#line 841 "cgipcode.asm"
    .dw pcall,get_setpoint
    .dw pcall,compute_top
    .dw psubwi,buf,3
    .dw pjump,decconv
setpoint_finger_end:
#line 454 "picweb.asm" 2

#line 1 "url.asm" 1
;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

; url.asm - URL processing.

.dseg
urlp:   .byte 2
url_enabled:    .byte 1
.cseg






;+
; the URL is in buf - 16 bytes of it anyway.
;
; /x?y=z
; 012345
;-

import_process_url:
process_url:
    ser r20
    sts url_enabled,r20         ; enable it

not_url_reset:
    lds r20,buf+1               ; /i  ?
    cpi r20,'i'
    brne not_an_image
    rjmp url_presentation
not_an_image:
    lds r20,buf+2    
    cpi r20,'?'                 ; check for command
    brne show_url
    lds r20,buf+1               ; URL name
    cpi r20,'x'
    brne show_url
    lds r20,buf+5               ; value
    lds r21,buf+3               ; bit number
    rcall exp2_r21              ; r22 = 1<<r21
    in r0,portd
    com r22
    and r0,r22                  ; clear bit
    andi r20,1                  ; 0/1
    breq out_it
    com r22                     ; back to just the bit
    or r0,r22
out_it:
    out portd,r0
    rjmp show_url
enable_enable:
    clr r0
    rjmp toggle1
toggle_enable:
    lds r0,url_enabled
toggle1:
    com r0
    sts url_enabled,r0
    rjmp url_next
not_seteep:
show_url:

    clr r10l
    rcall find_eeprom_lower
seeprom_htmlx:
    movw z,r20
	rjmp url_next1





url_next:
    ldsw z,urlp
url_next1:
    rcall url_load_eeprom_z
    adiw zl,1
    stsw urlp,z
    or r0,r0
    breq url_done

    mov r20,r0
    cpi r20,'{'                 ; toggle enabled
    breq    toggle_enable
    cpi r20,'}'                 ; enable it
    breq enable_enable

    lds r0,url_enabled
    or r0,r0
    breq url_next

    cpi r20,'`'                 ; URL CSI
    brne not_cmd
    rcall url_load_eeprom_z                         ; fetch command char
    adiw zl,1
    stsw urlp,z                 ; update pointer
    mov r20,r0                  ; command character

    cpi r20,'t'                 ; t - text header
    brne not_txt_hdr
    rcall text_header
    rjmp url_next
not_txt_hdr:
    movwi x,buf

    ; get the parms.
    rcall url_load_eeprom_z
    adiw zl,1
    st x+,r0
    ; get the second byte.
    rcall url_load_eeprom_z
    adiw zl,1
    st x+,r0
    stsw urlp,z

    movwi x,buf
    rcall hexcvtb               ; get result in i0

    movwi z,url_jumptab
    andi r20,7                  ; sorry - only 7 commands for now
    add zl,r20
    clr r21
    adc zh,r21                  ; get jump address
    ;
    ; NOTE WELL - target execution routines might want to pop the return
    ;             address and branch to the toggles - make sure the stack
    ;             is clean for such an action - toggles end up at url_next
    icall
    rjmp url_next
not_cmd:
    mov ch,r20
    rcall do_putchar
    rjmp url_next
url_done:
    ret
seeprom_html:   rjmp seeprom_htmlx  ; helper
url_jumptab:
    rjmp func0
    rjmp func1
    rjmp func2
    rjmp func3
    rjmp func4
    rjmp func5
    rjmp func6
;; function 7 - reference a "CGI" script from the upper index
    ldi r22h,'u'                ; force use of upper index
    rjmp do_image_html_i0
func0:
    mov r21,i0                      ; command parameter
    rcall exp2_r21                  ; r22 = 1<<r21
    in i0,portd
    and i0,r22
    breq funret
    popw z                          ; drop return address
    rjmp toggle_enable
func1:
    outstr intype ;;string intype "input type="
    ret
func2:
func3:
func4:
func5:
func6:
func7:
    putchar '?'
funret:
    ret
;+
; **-show_image-show an image.
;
; inputs:
;   url is in buf (1st 16 bytes)
; /iinn
; 012345
;
; only bytes 3, and 4 are decoded - and are the HEX image number to be sent.
;
; the image index is at EEPROM address 0000.  the first two bytes contain the
; number of entries in the index.  after that, there is an array of structures
; containing image address and length.
;   0000    .dw numimages
;   0002    .dw imgaddr,imglen      ; numimages of these
;
; return with ret - to finish off packet.
;-

url_presentation:
    movwi x,buf+3
    rcall hexcvtb       ; convert image # to i0
    lds r22h,buf+2      ; get x of "/ixNN"
do_image_html_i0:
    mov r10l,i0         ; save image #
    clrw y              ; assume index at low end
    cpi r22h,'u'        ; upper index
    brne not_upper_index
    movwi y,0x3800      ; address the upper index
not_upper_index:
    rcall find_eeprom
    brcs http404        ; sorry - not there
    bst r22h,6          ; check next to top bit
    brtc not_seeprom_html   ; not HTML - image
    bst r22h,7          ; check if both bits set
    brtc seeprom_html   ; no - it is straight HTML
    ;
    ; CGI pCode.  save pCode PC just in case of recursion
    ;
    pushw p
    rcall pcode
    .dw pcall|XX,(XX|XW|(20))   ; call indirect through R20
    .dw 0
    popw p
    ret
not_seeprom_html:
    rcall image
    bst r22h,7          ; check top bit of length
    brtc image_is_jpeg
    andi r22h,~(1<<7)   ; clear top bit
    outstr gif_hdr      ;;string gif_hdr "gif\n\n"
    rjmp go_image
image_is_jpeg:
    outstr jpg_hdr      ;;string jpg_hdr "jpeg\n\n"
go_image:
    movw y,r20          ; set start address
next_gif:
    rcall seeprom_read  ; get next byte from eeprom
    mov ch,i0
    rcall do_putchar    ; out she goes
    decw r22
    brne next_gif
    ret
contype:
    rcall http10
    outstr contype_msg  ;;string contype_msg "200\nContent-type: "
    ret
http404:
    rcall http10
    outstr http404_msg  ;;string http404_msg "404\n\n"
    ret
http10:
    outstr http10_msg   ;;string http10_msg "HTTP/1.0 "
    ret
image:
    rcall contype
    outstr image_str ;;string image_str "image/"
    ret
#line 273 "url.asm"


;+
; **-exp2_r21-compute 1<<r21.
;
; inputs:
;   r21 = power of 2 desired (0-7)
;
; outputs:
;   r22 = value
;-

exp2_r21:
    ldi r22,1                   ; will be our bit mask
    andi r21,7                  ; bit 0..7
exp2_loop:
    breq expret
    lsl r22
    dec r21
    rjmp exp2_loop

text_header:
    rcall contype
    outstr html_hdr ;;string html_hdr "text/html\n\n"
expret:
    ret

pre:
    outstr pre_str ;;string pre_str "<HTML><PRE>"
    ret
find_eeprom_lower:
    clrw y              ; SEEPROM address 0000
find_eeprom:
    movwi x,20          ; read into r20
    ldi r18l,2          ; get two byte # of index entries
    rcall seeprom_read_bytes    ; advances y by r18l bytes
    cp r10l,r20l        ; see if in range
    brsh sec_ret        ; sorry
    clr r10h            ; set up address
    shlw r10
    shlw r10            ; index entries are 4 bytes long
    addw y,r10          ; +base of index
    movwi x,20          ; read into r20, r22
    ldi r18l,4          ; 4 bytes
    rcall seeprom_read_bytes
    mov r18l,r20l
    or r18l,r20h        ; check if address of entity is 0000
    brne  clc_ret       ; nope - good stuff there
sec_ret:
    sec
    ret
clc_ret:
    clc
    ret
;+
; **-url_load_eeprom_z-load r0 with eeprom (serial) location (z).
;
; inputs:
;   z   = eeprom location
;
; outputs:
;   r0  = contents of that location
;
; notes:
;   this is here to emulate the "lpm" instruction which loads the content
;   (a byte) of the flash location pointed to by the "z" register into the
;   r0 regiser.
;-



url_load_eeprom_z:
    movw y,z
    rcall seeprom_read
    mov r0,i0
    ret


#line 455 "picweb.asm" 2


.cseg
.include "picweb.asi"
.eseg
.include "picweb.esi"
