#! /usr/local/perl
#
#  Ping check
#
$ping = 'ping';
$debug = 0;

select((select(STDOUT), $| = 1)[0]);    # unbuffer output

$ip = shift;
exit(1) if (($ip = &getip($ip)) eq '');

$cmd = "$ping -n 1 $ip";
print "$cmd\n" if ($debug);

for ($try = 0; $try < 3; ++$try) {
	$s = `$cmd`;
	print "results: $s\n" if ($debug);
	printf("status: %x %x\n", $?, $?>>8) if ($debug);
	###############################################################
	# Good:
	# 64 bytes from 192.245.227.127: icmp_seq=0 ttl=64 time=4.3 ms
	# Reply from 192.245.227.127: bytes=32 time=4ms TTL=32
	#
	# Bad:
	# <nothing>
	# Reply from 142.42.27.33: Destination net unreachable.
	###############################################################
	if ($s =~ /from.*[=]/) {
		print "$ip is alive!\n" if ($debug);
		exit 0;
	}
}
print "$ip is dead!\n";
exit 1;
#
#  Resolve IP address
#  usage: exit(1) if (($ip = &getip($ip)) eq '');
#         where $s is IP address, '-', or @file
#
sub getip {
	local($f) = @_;

	$ip = '';
	if ($f =~ /^[@]/ || $f eq '-') {
		if ($f ne '-') {
			$f =~ s/^[@]//;
			if (!open(IP, "<$f")) {
				print STDERR "Can't open IP address file \"$f\"!\n";
				return '';
			}
		}
		while(1) {
			if ($f ne '-') { $s = <IP>; } else { $s = <>; }
			##print "$s";
			last if ($s eq '');
			if ($s =~ /^\s*(\d+[.]\d+[.]\d+[.]\d+)[\r\n\s]*$/) {
				$ip = $1;
			}
		}
	} else {
		$ip = $f;
	}
	if ($ip =~ /^\d+[.]\d+[.]\d+[.]\d+$/) {
		return $ip;
	} else {
		print STDERR "IP address ($ip) not of the form x.y.z.w!\n";
		return '';
	}
}
