;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

.macro stxi
    ldi w,@0
    st x+,w
.endmacro

.equ pcode_signature = 0x95a8
.equ pcode_arg_mask = 3

.macro andwi
    andi @0l,low(@1)
    andi @0h,high(@1)
.endmacro

.macro pcode_routine
    .dw @0|pcode_signature
.endmacro

.macro label
.set @0 = pc
.endmacro

.macro coroutine
    pop zh
    pop zl
.endm

.macro ldsw
    lds @0l,@1
    lds @0h,@1+1
.endmacro

.macro stsw
    sts @0,@1l
    sts @0+1,@1h
.endmacro

.macro pushw
    push @0h
    push @0l
.endmacro

.macro popw
    pop @0l
    pop @0h
.endmacro

.macro shrw
    lsr @0h
    ror @0l
.endmacro

.macro shlw
    lsl @0l
    rol @0h
.endmacro

.macro tstb
    mov w,@1
    and w,@0
.endmacro

.macro tstbi
    ldi w,@1
    and w,@0
.endmacro

.macro cmpw
    cp @0l,@1l
    cpc @0h,@1h
.endmacro

.macro cmpwi
    cpi @0l,low(@1)
    ldi w,high(@1)
    cpc @0h,w
.endmacro

.macro  coroutine_call
    pop zh
    pop zl
    icall
.endmacro

.macro coroutine_done
    pop zh
    pop zl
.endmacro

.macro coroutine_return
    push    zl
    push zh
    ret
.endmacro

.macro coroutine_setup
    push    zl
    push    zh
.endmacro

.macro putchar
	ldi	ch,@0
	rcall import_do_putchar
.endmacro

.macro hexb
    rcall do_hexb
.endmacro

.macro space
    rcall do_space
.endmacro

.macro crlf
    rcall do_crlf
.endmacro

.macro addwi
    ldi w,low(@1)
    add @0l,w
    ldi w,high(@1)
    adc @0h,w
.endmacro

.macro addw
    add @0l,@1l
    adc @0h,@1h
.endmacro

.macro subwi
    ldi w,low(@1)
    sub @0l,w
    ldi w,high(@1)
    sbc @0h,w
.endmacro

.macro subw
    sub @0l,@1l
    sbc @0h,@1h
.endmacro

.macro movwi
	ldi	@0l,low(@1)
	ldi	@0h,high(@1)
.endmacro

.macro clrw
    clr @0l
    clr @0h
.endmacro

.macro decw
    subi @0l,1
    sbci @0h,0
.endmacro

.macro incw
    subi @0l,-1
    sbci @0h,-1
.endmacro

.macro ldsbw
	lds	@0l,@1
    clr @0h
.endmacro

.macro movw
    mov @0l,@1l
    mov @0h,@1h
.endmacro

.macro outstr
    rcall import_do_outstr
	.dw	(@0*2)
.endmacro

.macro hexy
    rcall hexy
.endmacro

.macro outstrs
	ldi	yl,low(@0)
	ldi	yh,high(@0)
    rcall do_outstrs
.endmacro

.macro setport
    ldi r16,@1
    mov i0,r16
    ldi r16,@0
    rcall isa_out
.endmacro

.macro isa_out
    rcall   isa_out
.endmacro

.def r0l =r0
.def r0h =r1
.def r1l =r1
.def i0 =r2
.def r1h =r2
.def r2l =r2
.def i1 =r3
.def r2h =r3
.def r3l =r3
;.def i2 =r4
;.def r3h =r4
;.def r4l =r4
;.def r4h =r5
;.def r5l =r5
.def pl=r4
.def ph=r5  ; pcode PC low, high
;.def r5h =r6
.def r6l =r6
.def r6h =r7
.def r7l =r7
.def r7h =r8
.def r8l =r8
.def r8h =r9
.def r9l =r9
.def r9h =r10
.def r10l =r10
.def r10h =r11
.def r11l =r11
.def r11h =r12
.def r12l =r12
.def r12h =r13
.def r13l =r13
.def r13h =r14
.def r14l =r14
.def r14h =r15
.def r15l =r15
.def r15h =r16
.def r16l =r16
.def r16h =r17
.def r17l =r17
.def r17h =r18
.def r18l =r18
.def r18h =r19
.def r19l =r19
.def r19h =r20
.def r20l =r20
.def r20h =r21
.def r21l =r21
.def r21h =r22
.def r22l =r22
.def r22h =r23
.def r23l =r23
.def r23h =r24
;; reserved for macros.
.def r24l = r24
.def r24h = r25

;.def wl   =r24
.def w    =r25
;.def wh   =r25
;.def w1   =r25

.def r25h =r26
.def r26l =r26
.def xl  =r26
.def r26h =r27
.def r27l =r27
.def xh  =r27

.def r27h =r28
.def r28l =r28
.def yll  =r28
.def r28h =r29
.def r29l =r29
.def ylh  =r29

.def r29h =r30
.def r30l =r30
.def zl  =r30
.def r30h =r31
.def r31l =r31
.def zh  =r31
