;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

#define BUF_WRAP    (max_nch-1)

com_circular:
    lds r17,com_in      ; get IN index
    lds r18,com_out     ;  and OUT index
    inc r17
    andi r17,BUF_WRAP   ; wrap it
    cp r17,r18          ; check it
    breq count_lost     ; sorry - we lost a char

    pushw z
    clr zh
    lds zl,com_in
    addwi z,inbuf
    in r18,udr
    st z,r18
    popw z

    sts com_in,r17      ; advance IN index
    rjmp com_bail       ; bail out
count_lost:
    in r18,udr          ; dump the byte to clear interrupt
    lds r17,com_lost
    inc r17
    sts com_lost,r17
    rjmp com_bail

rx_isr:
    push w
	push	r17
	push    r18
	in	r18,sreg
	push r18
    lds r18,serial_mode
    tst r18
    brne com_circular
	in	r17,udr
	cpi	r17,3	    ; Control-C does a reset
	breq	gores
	push	yl
	push	yh
	cpi r17,0x13    ; control-S - set xof flag
	breq go_xoff
	cpi r17,0x11    ; control-Q - clear xof flag
	breq go_xoff
	lds	r18,ready
	tst	r18
	brne	rxignore
	cpi	r17,0x0d
	brne	nocr
is_cr:
	sts	ready,r17
	rjmp	rxignore
go_xoff:
	andi    r17,2       ; isolate on/off bit
	sts xoff,r17
	rjmp rxignore
nocr:
    cpi r17,0x0a        ; also allow LF
    breq is_cr
	lds	yl,nch
	ldi yh,0
	cpi	yl,max_nch
	brlt	rxok
	ldi	r17,'!'
	rjmp	rxecho
rxok:
	mov	r18,yl
	addwi y,inbuf
	st	y,r17
	inc	r18
	sts	nch,r18
rxecho:
	out	udr,r17
rxignore:
	pop	yh
	pop	yl
com_bail:
	pop	r18
	out	sreg,r18
	pop	r18
	pop	r17
    pop w
	reti
gores:
    pop r17
    pop r17
    pop r17
    pop r17

; stack is in same state as on initial entry to interrupt.

    pop yh
    pop yl
    stsw ccaddr,y
    rjmp reset1
import_do_putchar:
do_putchar:
	push    r17
	lds r17,putc_b          ; check if going to board
	tst r17
    brne putc_to_board
	lds r17,putcok
	tst r17
	breq putc_off
wait_xon:
	lds r17,xoff            ; check xof flag
	or r17,r17
	brne wait_xon
do_put1:
	in	r17,usr
	bst	r17,udre	; check if data register empty
	brtc	do_put1
	out	udr,ch		; start transmission
putc_off:
	pop r17
	ret
putc_to_board:
	rcall do_bputc
	rjmp putc_off
;+
; **-pser_mode-pcode set mode on serial port.
;
; inputs:
;   r10l = mode as: 0-normal, non-zero-enable pass-all (binary) mode.
;
; outputs:
;   buffer flushed and characters being stored appropriately.
;-

pser_mode:  pcode_routine   1
    clr r10h
 	ldi	r17,(1<<rxen)|(1<<txen)     ; disable receive interrupts
	out	UCR,r17
    tst r10l
    breq psb_normal
    ;
    ; entering binary mode - reset buffer pointers if not already in
    ; binary mode.
    ;
    lds r17,serial_mode
    cp r17,r10l
    breq pserial_noreset
    sts com_in,r10h
    sts com_out,r10h
pserial_noreset:
    inc r10h
pserial_done:
 	ldi	r17,(1<<rxcie)|(1<<rxen)|(1<<txen)     ; enable receive interrupts
	out	UCR,r17
    sts serial_mode,r10h
    ret
psb_normal:
    sts nch,r10h
    rjmp pserial_done
;+
; **-pser_putc-pcode serial port putchar.
;
; inputs:
;   r10 = character to transmit
;
; outputs:
;   transmission to serial port initiated.
;
; notes:
;   waits for a "transmit done" indication on the serial port
;   before transmitting this character.
;-

pser_putc:  pcode_routine 1
    push r17
    mov ch,r10l
    rjmp do_put1
;+
; **-pser_getc-pcode serial port getchar.
;
; outputs:
;   r10 -> resulting byte
;   condition codes set so that a jumpeq will take if buffer empty.
;-

pser_getc:  pcode_routine   1
    lds r17,com_in
    lds r18,com_out
    cp r17,r18
    brne pser_getc_got_byte
    rjmp set_pcode_flags
pser_getc_got_byte:
    movw x,r10              ; where to store it
    mov zl,r18              ; get OUT index low 1/2
    clr zh                  ; clear top 1/2
    addwi z,inbuf           ; bias for buffer
    ld r12l,z               ; get the byte
    st x,r12l               ; store it
    inc r18
    andi r18,BUF_WRAP       ; wrap it
    sts com_out,r18         ; store it back
    clz
    rjmp set_pcode_flags    ; jumpne will take now
