# strings.pl - string "compiler"
#
# records are:
# label "string"
#
&init() ;
if (open(V,"<version"))  {
    $_ = scalar(<V>) ;
    ($version=$_) =~ s/[\r\n]*$// ;
    close(V) ;
} else {
	$version = '???';
}
$strpre = shift ARGV ;

while (<ARGV>)  {
    if (/$strpre[\s]+([^\s]+)[\s]+["](.*)["][\s\r\n]*$/)  {
        $label = $1 ;
        $ostr = $2 ;
        $str = $ostr ;
        $str =~ s/\$\$VERSION\$\$/$version/g ;
        $ostr =~ s/\$\$VERSION\$\$/$version/g ;
        $str =~ s/\\([rnt])/$ct{$1}/eg ;
        $str = $str."\0" ;        # put in the trailing NUL
        print "$label:\t\t; $ostr\n" ;     # label first
        for ($i=0 ; $i<length($str) ; $i+=2)  {
            printf "\t.dw 0x%04X\n",unpack("S",substr($str,$i,2)) ;
        }
    }
}

sub init  {
    %ct = (
        "r","\r",
        "n","\n",
        "t","\t"
    ) ;
}
