;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

#define _FIN     0x0001
#define _SYN     0x0002
#define _RST     0x0004
#define _PUSH    0x0008
#define _ACK     0x0010
#define _DO_B(x)  (((x/4)+5)<<12)
#define _DO      _DO_B(0)
;    unsigned        hdrlen  : 4;
;    unsigned        ver     : 4;
;    byte            tos;
;    word            length;
;    word            identification;
;    unsigned        frags : 3;
;    unsigned        fo    : 13;
;    byte            ttl;
;    byte            proto;
;    word            checksum;
;    longword        source;
;    longword        destination;
.equ IPH = (6+6+2)			    ; offset from start of frame to start of ip hdr
.equ IPD = IPH+20               ; offset to start of IP data
.equ IP_HVTOS   = IPH+0
.equ IP_LEN     = IPH+2
.equ IP_ID      = IPH+4
.equ IP_FFO     = IPH+6
.equ IP_TTLP    = IPH+8
.equ IP_CHKSUM  = IPH+10
.equ IP_SRCADDR = IPH+12
.equ IP_DSTADDR = IPH+16
#define IP_HEADER_LEN  20

;;; start of TCP header.
;    word            srcPort;
;    word            dstPort;
;    longword        seqnum;
;    longword        acknum;
;    word            flags;
;    word            window;
;    word            checksum;
;    word            urgentPointer;
.equ TCP_HEADER = IPD+0
.equ TCP_SP     = IPD+0
.equ TCP_DP     = IPD+2
.equ TCP_SEQ    = IPD+4
.equ TCP_ACK    = IPD+8
.equ TCP_FLAGS  = IPD+12
.equ TCP_WIN    = IPD+14
.equ TCP_CHKSUM = IPD+16
.equ TCP_URG    = IPD+18
.equ TCP_DATA   = IPD+20
.equ TCP_HEADER_LEN = 20
.equ UDP_HEADER = IPD+0
.equ UDP_SP         = UDP_HEADER+0
.equ UDP_DP         = UDP_HEADER+2
.equ UDP_LEN        = UDP_HEADER+4
.equ UDP_CHKSUM     = UDP_HEADER+6
.equ UDP_DATA       = UDP_HEADER+8
#define UDP_HEADER_LEN 8

#define SET_ADDL(val)      \
    .dw pmovwi,buf+4,byte4(val)|(byte3(val)<<8),pmovwi,buf+6,byte2(val)|(low(val)<<8)
#define R2X_ADDL(to,from)   \
    .dw pr2s,buf,from,4,paddn,buf,buf+4,4,ps2x,to,buf,4
#define R2X_LONG(to,from)  .dw pr2x,to,from,4
#define R2X_WORD(to,from)  .dw pr2x,to,from,2
#define	SET_IP(i,l,a,b,c,d)  .dw i,l,a|(b<<8),i,l+2,c|(d<<8)

#define BSWAP(v)  ((low(v)<<8)|high(v))
#define ETH_PT rcv_hdr+en_rbuf_nhdr+6+6
