;-------------------------------------------------------------------------
; Copyright (c) 1999 Steven Freyder, David Helland, and Bruce D. Lightner.
; Use subject to licensing restrictions described in "PICOWEB SERVER
; SOFTWARE LICENSE AGREEMENT DATED JULY 14, 1999" (See file LICENSE.txt).
;-------------------------------------------------------------------------

; url.asm - URL processing.

.dseg
urlp:   .byte 2
url_enabled:    .byte 1
.cseg

#if !defined(URL_IN_EEPROM)
#define url_lpm lpm
#else
#define url_lpm rcall url_load_eeprom_z
#endif
;+
; the URL is in buf - 16 bytes of it anyway.
;
; /x?y=z
; 012345
;-

import_process_url:
process_url:
    ser r20
    sts url_enabled,r20         ; enable it

not_url_reset:
    lds r20,buf+1               ; /i  ?
    cpi r20,'i'
    brne not_an_image
    rjmp url_presentation
not_an_image:
    lds r20,buf+2    
    cpi r20,'?'                 ; check for command
    brne show_url
    lds r20,buf+1               ; URL name
    cpi r20,'x'
    brne show_url
    lds r20,buf+5               ; value
    lds r21,buf+3               ; bit number
    rcall exp2_r21              ; r22 = 1<<r21
    in r0,portd
    com r22
    and r0,r22                  ; clear bit
    andi r20,1                  ; 0/1
    breq out_it
    com r22                     ; back to just the bit
    or r0,r22
out_it:
    out portd,r0
    rjmp show_url
enable_enable:
    clr r0
    rjmp toggle1
toggle_enable:
    lds r0,url_enabled
toggle1:
    com r0
    sts url_enabled,r0
    rjmp url_next
not_seteep:
show_url:
#if defined(URL_IN_EEPROM)
    clr r10l
    rcall find_eeprom_lower
seeprom_htmlx:
    movw z,r20
	rjmp url_next1
#else
    movwi z,url_data*2
    stsw urlp,z
#endif

url_next:
    ldsw z,urlp
url_next1:
    url_lpm
    adiw zl,1
    stsw urlp,z
    or r0,r0
    breq url_done

    mov r20,r0
    cpi r20,'{'                 ; toggle enabled
    breq    toggle_enable
    cpi r20,'}'                 ; enable it
    breq enable_enable

    lds r0,url_enabled
    or r0,r0
    breq url_next

    cpi r20,'`'                 ; URL CSI
    brne not_cmd
    url_lpm                         ; fetch command char
    adiw zl,1
    stsw urlp,z                 ; update pointer
    mov r20,r0                  ; command character

    cpi r20,'t'                 ; t - text header
    brne not_txt_hdr
    rcall text_header
    rjmp url_next
not_txt_hdr:
    movwi x,buf

    ; get the parms.
    url_lpm
    adiw zl,1
    st x+,r0
    ; get the second byte.
    url_lpm
    adiw zl,1
    st x+,r0
    stsw urlp,z

    movwi x,buf
    rcall hexcvtb               ; get result in i0

    movwi z,url_jumptab
    andi r20,7                  ; sorry - only 7 commands for now
    add zl,r20
    clr r21
    adc zh,r21                  ; get jump address
    ;
    ; NOTE WELL - target execution routines might want to pop the return
    ;             address and branch to the toggles - make sure the stack
    ;             is clean for such an action - toggles end up at url_next
    icall
    rjmp url_next
not_cmd:
    mov ch,r20
    rcall do_putchar
    rjmp url_next
url_done:
    ret
seeprom_html:   rjmp seeprom_htmlx  ; helper
url_jumptab:
    rjmp func0
    rjmp func1
    rjmp func2
    rjmp func3
    rjmp func4
    rjmp func5
    rjmp func6
;; function 7 - reference a "CGI" script from the upper index
    ldi r22h,'u'                ; force use of upper index
    rjmp do_image_html_i0
func0:
    mov r21,i0                      ; command parameter
    rcall exp2_r21                  ; r22 = 1<<r21
    in i0,portd
    and i0,r22
    breq funret
    popw z                          ; drop return address
    rjmp toggle_enable
func1:
    outstr intype ;;string intype "input type="
    ret
func2:
func3:
func4:
func5:
func6:
func7:
    putchar '?'
funret:
    ret
;+
; **-show_image-show an image.
;
; inputs:
;   url is in buf (1st 16 bytes)
; /iinn
; 012345
;
; only bytes 3, and 4 are decoded - and are the HEX image number to be sent.
;
; the image index is at EEPROM address 0000.  the first two bytes contain the
; number of entries in the index.  after that, there is an array of structures
; containing image address and length.
;   0000    .dw numimages
;   0002    .dw imgaddr,imglen      ; numimages of these
;
; return with ret - to finish off packet.
;-

url_presentation:
    movwi x,buf+3
    rcall hexcvtb       ; convert image # to i0
    lds r22h,buf+2      ; get x of "/ixNN"
do_image_html_i0:
    mov r10l,i0         ; save image #
    clrw y              ; assume index at low end
    cpi r22h,'u'        ; upper index
    brne not_upper_index
    movwi y,CGI_INDEX_BASE      ; address the upper index
not_upper_index:
    rcall find_eeprom
    brcs http404        ; sorry - not there
    bst r22h,6          ; check next to top bit
    brtc not_seeprom_html   ; not HTML - image
    bst r22h,7          ; check if both bits set
    brtc seeprom_html   ; no - it is straight HTML
    ;
    ; CGI pCode.  save pCode PC just in case of recursion
    ;
    pushw p
    rcall pcode
    .dw pcall|XX,WORD(20)   ; call indirect through R20
    .dw 0
    popw p
    ret
not_seeprom_html:
    rcall image
    bst r22h,7          ; check top bit of length
    brtc image_is_jpeg
    andi r22h,~(1<<7)   ; clear top bit
    outstr gif_hdr      ;;string gif_hdr "gif\n\n"
    rjmp go_image
image_is_jpeg:
    outstr jpg_hdr      ;;string jpg_hdr "jpeg\n\n"
go_image:
    movw y,r20          ; set start address
next_gif:
    rcall seeprom_read  ; get next byte from eeprom
    mov ch,i0
    rcall do_putchar    ; out she goes
    decw r22
    brne next_gif
    ret
contype:
    rcall http10
    outstr contype_msg  ;;string contype_msg "200\nContent-type: "
    ret
http404:
    rcall http10
    outstr http404_msg  ;;string http404_msg "404\n\n"
    ret
http10:
    outstr http10_msg   ;;string http10_msg "HTTP/1.0 "
    ret
image:
    rcall contype
    outstr image_str ;;string image_str "image/"
    ret
#if defined(FLASH_IMAGES)
flash_jpg:
    rcall image
    outstr gif_hdr
    movwi z,flash_jpg_data*2
    url_lpm
    mov r20l,r0
    ori zl,1
    url_lpm
    mov r20h,r0
    adiw zl,1
    clr i0
next_fl_jpg:
    url_lpm
    dec i0
    brne next_fl_jpg
    adiw zl,1
    mov ch,r0
    rcall do_putchar
    decw r20
    brne next_fl_jpg
    ret
#endif

;+
; **-exp2_r21-compute 1<<r21.
;
; inputs:
;   r21 = power of 2 desired (0-7)
;
; outputs:
;   r22 = value
;-

exp2_r21:
    ldi r22,1                   ; will be our bit mask
    andi r21,7                  ; bit 0..7
exp2_loop:
    breq expret
    lsl r22
    dec r21
    rjmp exp2_loop

text_header:
    rcall contype
    outstr html_hdr ;;string html_hdr "text/html\n\n"
expret:
    ret

pre:
    outstr pre_str ;;string pre_str "<HTML><PRE>"
    ret
find_eeprom_lower:
    clrw y              ; SEEPROM address 0000
find_eeprom:
    movwi x,20          ; read into r20
    ldi r18l,2          ; get two byte # of index entries
    rcall seeprom_read_bytes    ; advances y by r18l bytes
    cp r10l,r20l        ; see if in range
    brsh sec_ret        ; sorry
    clr r10h            ; set up address
    shlw r10
    shlw r10            ; index entries are 4 bytes long
    addw y,r10          ; +base of index
    movwi x,20          ; read into r20, r22
    ldi r18l,4          ; 4 bytes
    rcall seeprom_read_bytes
    mov r18l,r20l
    or r18l,r20h        ; check if address of entity is 0000
    brne  clc_ret       ; nope - good stuff there
sec_ret:
    sec
    ret
clc_ret:
    clc
    ret
;+
; **-url_load_eeprom_z-load r0 with eeprom (serial) location (z).
;
; inputs:
;   z   = eeprom location
;
; outputs:
;   r0  = contents of that location
;
; notes:
;   this is here to emulate the "lpm" instruction which loads the content
;   (a byte) of the flash location pointed to by the "z" register into the
;   r0 regiser.
;-

#if defined(URL_IN_EEPROM)

url_load_eeprom_z:
    movw y,z
    rcall seeprom_read
    mov r0,i0
    ret

#endif
